/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.as7.extension.admin;

import java.util.EnumSet;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.switchyard.admin.Component;
import org.switchyard.admin.ComponentType;
import org.switchyard.admin.SwitchYard;
import org.switchyard.as7.extension.admin.ModelNodeCreationUtil;
import org.switchyard.as7.extension.services.SwitchYardAdminService;

public final class SwitchYardSubsystemReadComponent
implements OperationStepHandler {
    public static final SwitchYardSubsystemReadComponent INSTANCE = new SwitchYardSubsystemReadComponent();

    private SwitchYardSubsystemReadComponent() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                ServiceController controller = context.getServiceRegistry(false).getRequiredService(SwitchYardAdminService.SERVICE_NAME);
                ModelNode components = context.getResult();
                SwitchYard switchYard = (SwitchYard)SwitchYard.class.cast(controller.getService().getValue());
                if (operation.hasDefined("name")) {
                    String componentName = operation.get("name").asString();
                    Component component = switchYard.getComponent(componentName);
                    if (component != null) {
                        components.add(ModelNodeCreationUtil.createComponentNode(component));
                    }
                } else {
                    EnumSet<ComponentType> desiredComponentTypes = operation.hasDefined("type") && !"all".equalsIgnoreCase(operation.get("type").asString()) ? EnumSet.of(ComponentType.valueOf((String)operation.get("type").asString().toUpperCase())) : EnumSet.allOf(ComponentType.class);
                    for (Component component : switchYard.getComponents()) {
                        if (!desiredComponentTypes.contains(component.getType())) continue;
                        components.add(ModelNodeCreationUtil.createComponentNode(component));
                    }
                }
                context.completeStep();
            }
        }, OperationContext.Stage.RUNTIME);
        context.completeStep();
    }
}

