/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.as7.extension.admin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.switchyard.admin.Application;
import org.switchyard.admin.Reference;
import org.switchyard.admin.SwitchYard;
import org.switchyard.as7.extension.admin.ModelNodeCreationUtil;
import org.switchyard.as7.extension.services.SwitchYardAdminService;

public final class SwitchYardSubsystemReadReference
implements OperationStepHandler {
    public static final SwitchYardSubsystemReadReference INSTANCE = new SwitchYardSubsystemReadReference();

    private SwitchYardSubsystemReadReference() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                ServiceController controller = context.getServiceRegistry(false).getRequiredService(SwitchYardAdminService.SERVICE_NAME);
                List<Object> references = Collections.emptyList();
                SwitchYard switchYard = (SwitchYard)SwitchYard.class.cast(controller.getService().getValue());
                if (operation.hasDefined("application-name")) {
                    QName applicationName = QName.valueOf(operation.get("application-name").asString());
                    Application application = switchYard.getApplication(applicationName);
                    if (application != null) {
                        if (operation.hasDefined("reference-name")) {
                            Reference reference = SwitchYardSubsystemReadReference.this.findReference(QName.valueOf(operation.get("reference-name").asString()), application);
                            if (reference != null) {
                                references = Collections.singletonList(reference);
                            }
                        } else {
                            references = application.getReferences();
                        }
                    }
                } else if (operation.hasDefined("reference-name")) {
                    QName referenceName = QName.valueOf(operation.get("reference-name").asString());
                    references = new ArrayList();
                    for (Application application : switchYard.getApplications()) {
                        Reference reference = SwitchYardSubsystemReadReference.this.findReference(referenceName, application);
                        if (reference == null) continue;
                        references.add(reference);
                    }
                } else {
                    references = switchYard.getReferences();
                }
                SwitchYardSubsystemReadReference.this.addReferenceNodes(context.getResult(), references);
                context.stepCompleted();
            }
        }, OperationContext.Stage.RUNTIME);
        context.stepCompleted();
    }

    private void addReferenceNodes(ModelNode result, List<Reference> references) {
        for (Reference reference : references) {
            result.add(ModelNodeCreationUtil.createReferenceNode(reference));
        }
    }

    private Reference findReference(QName referenceName, Application application) {
        for (Reference reference : application.getReferences()) {
            if (!referenceName.equals(reference.getName())) continue;
            return reference;
        }
        return null;
    }
}

