/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.as7.extension.services;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.naming.context.NamespaceContextSelector;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.switchyard.as7.extension.deployment.SwitchYardDeployment;
import org.switchyard.deploy.Component;

public class SwitchYardService
implements Service<SwitchYardDeployment> {
    private static final Logger LOG = Logger.getLogger((String)"org.switchyard");
    public static final ServiceName SERVICE_NAME = ServiceName.of((String[])new String[]{"SwitchYardService"});
    private final InjectedValue<NamespaceContextSelector> _namespaceSelector = new InjectedValue();
    private final List<InjectedValue<Component>> _components = new ArrayList<InjectedValue<Component>>();
    private SwitchYardDeployment _switchyardDeployment;

    public SwitchYardService(SwitchYardDeployment switchyardDeployment) {
        this._switchyardDeployment = switchyardDeployment;
    }

    public SwitchYardDeployment getValue() throws IllegalStateException, IllegalArgumentException {
        return this._switchyardDeployment;
    }

    public void start(StartContext context) throws StartException {
        try {
            NamespaceContextSelector selector = (NamespaceContextSelector)this._namespaceSelector.getValue();
            NamespaceContextSelector.pushCurrentSelector((NamespaceContextSelector)selector);
            LOG.info((Object)"Starting SwitchYard service");
            ArrayList<Component> components = new ArrayList<Component>();
            for (InjectedValue<Component> component : this._components) {
                components.add((Component)component.getValue());
            }
            this._switchyardDeployment.setNamespaceContextSelector(selector);
            this._switchyardDeployment.start(components);
        }
        catch (Exception e) {
            try {
                this._switchyardDeployment.stop();
            }
            catch (Exception ex) {
                LOG.error((Object)ex);
            }
            throw new StartException((Throwable)e);
        }
        finally {
            NamespaceContextSelector.popCurrentSelector();
        }
    }

    public void stop(StopContext context) {
        this._switchyardDeployment.stop();
    }

    public InjectedValue<NamespaceContextSelector> getNamespaceSelector() {
        return this._namespaceSelector;
    }

    public InjectedValue<Component> getComponent() {
        InjectedValue component = new InjectedValue();
        if (!this._components.contains(component)) {
            this._components.add((InjectedValue<Component>)component);
        }
        return component;
    }
}

