/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.as7.extension.cluster;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.NamingException;
import javax.xml.namespace.QName;
import org.apache.catalina.Container;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.startup.ContextConfig;
import org.apache.coyote.http11.Http11Protocol;
import org.apache.tomcat.InstanceManager;
import org.jboss.as.web.deployment.WebCtxLoader;
import org.jboss.logging.Logger;
import org.switchyard.ServiceDomain;
import org.switchyard.as7.extension.ExtensionLogger;
import org.switchyard.as7.extension.ExtensionMessages;
import org.switchyard.as7.extension.util.ServerUtil;
import org.switchyard.component.sca.RemoteEndpointPublisher;
import org.switchyard.component.sca.SwitchYardRemotingServlet;

public class RemoteEndpointListener
implements RemoteEndpointPublisher {
    private static final String SERVER_TEMP_DIR = System.getProperty("jboss.server.temp.dir");
    private static final String SERVLET_NAME = "SwitchYardRemotingServlet";
    private static Logger _log = Logger.getLogger(RemoteEndpointListener.class);
    private String _contextName;
    private StandardContext _serverContext;
    private Map<QName, ServiceDomain> _services = new ConcurrentHashMap<QName, ServiceDomain>();
    private boolean _disableRemoteTransaction = false;
    private boolean _started;

    public void init(String context) {
        this._contextName = context;
    }

    public synchronized void start() throws Exception {
        File docBase;
        if (this._started) {
            return;
        }
        Host host = ServerUtil.getDefaultHost().getHost();
        this._serverContext = (StandardContext)host.findChild("/" + this._contextName);
        if (this._serverContext == null) {
            this._serverContext = new StandardContext();
            this._serverContext.setPath("/" + this._contextName);
            docBase = new File(SERVER_TEMP_DIR, this._contextName);
            if (!docBase.exists() && !docBase.mkdirs()) {
                throw ExtensionMessages.MESSAGES.unableToCreateTempDirectory(docBase.getPath());
            }
        } else {
            throw ExtensionMessages.MESSAGES.contextAlreadyExists(this._contextName);
        }
        this._serverContext.setDocBase(docBase.getPath());
        this._serverContext.addLifecycleListener((LifecycleListener)new ContextConfig());
        WebCtxLoader loader = new WebCtxLoader(Thread.currentThread().getContextClassLoader());
        loader.setContainer((Container)host);
        this._serverContext.setLoader((Loader)loader);
        this._serverContext.setInstanceManager((InstanceManager)new LocalInstanceManager());
        Wrapper wrapper = this._serverContext.createWrapper();
        wrapper.setName(SERVLET_NAME);
        wrapper.setServletClass(SwitchYardRemotingServlet.class.getName());
        wrapper.setLoadOnStartup(1);
        this._serverContext.addChild((Container)wrapper);
        this._serverContext.addServletMapping("/*", SERVLET_NAME);
        host.addChild((Container)this._serverContext);
        this._serverContext.create();
        this._serverContext.start();
        SwitchYardRemotingServlet remotingServlet = (SwitchYardRemotingServlet)wrapper.getServlet();
        remotingServlet.setEndpointPublisher((RemoteEndpointPublisher)this);
        _log.info((Object)("Published Remote Service Endpoint " + this._serverContext.getPath()));
        this._started = true;
    }

    public synchronized void stop() throws Exception {
        if (this._serverContext != null && !this._serverContext.getPath().equals("/")) {
            try {
                Container container = this._serverContext.getParent();
                container.removeChild((Container)this._serverContext);
                this._serverContext.stop();
                this._serverContext.destroy();
                _log.info((Object)("Destroyed HTTP context " + this._serverContext.getPath()));
            }
            catch (Exception e) {
                ExtensionLogger.ROOT_LOGGER.unableToDestroyWebContext(this._contextName, e);
            }
        }
    }

    public String getAddress() {
        String hostAddress = null;
        Connector connector = ServerUtil.getDefaultConnector();
        if (connector.getProtocolHandler() instanceof Http11Protocol) {
            Http11Protocol protocol = (Http11Protocol)connector.getProtocolHandler();
            InetAddress address = protocol.getAddress();
            hostAddress = address.getHostAddress();
        } else {
            ExtensionLogger.ROOT_LOGGER.unableToDetermineHostAddress();
            hostAddress = ServerUtil.getDefaultHost().getHost().findAliases()[0];
        }
        return connector.getScheme() + "://" + hostAddress + ":" + connector.getPort() + "/" + this._contextName;
    }

    public void addService(QName serviceName, ServiceDomain domain) {
        this._services.put(serviceName, domain);
    }

    public void removeService(QName serviceName, ServiceDomain domain) {
        this._services.remove(serviceName);
    }

    public ServiceDomain getDomain(QName serviceName) {
        return this._services.get(serviceName);
    }

    public RemoteEndpointPublisher setDisableRemoteTransaction(boolean disable) {
        this._disableRemoteTransaction = disable;
        return this;
    }

    public boolean isDisableRemoteTransaction() {
        return this._disableRemoteTransaction;
    }

    private static class LocalInstanceManager
    implements InstanceManager {
        LocalInstanceManager() {
        }

        public Object newInstance(String className) throws IllegalAccessException, InvocationTargetException, NamingException, InstantiationException, ClassNotFoundException {
            return Class.forName(className).newInstance();
        }

        public Object newInstance(String fqcn, ClassLoader classLoader) throws IllegalAccessException, InvocationTargetException, NamingException, InstantiationException, ClassNotFoundException {
            return Class.forName(fqcn, false, classLoader).newInstance();
        }

        public Object newInstance(Class<?> c) throws IllegalAccessException, InvocationTargetException, NamingException, InstantiationException {
            return c.newInstance();
        }

        public void newInstance(Object o) throws IllegalAccessException, InvocationTargetException, NamingException {
            throw new IllegalStateException();
        }

        public void destroyInstance(Object o) throws IllegalAccessException, InvocationTargetException {
        }
    }
}

