/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.as7.extension.deployment;

import java.util.List;
import javax.xml.namespace.QName;
import org.apache.camel.spi.ThreadPoolFactory;
import org.jboss.as.controller.PathElement;
import org.jboss.as.naming.context.NamespaceContextSelector;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jboss.msc.service.ServiceController;
import org.switchyard.ServiceDomain;
import org.switchyard.admin.Application;
import org.switchyard.admin.base.BaseSwitchYard;
import org.switchyard.as7.extension.admin.ModelNodeCreationUtil;
import org.switchyard.as7.extension.camel.JBossThreadPoolFactory;
import org.switchyard.as7.extension.camel.NamespaceContextPolicy;
import org.switchyard.as7.extension.deployment.SwitchYardDeploymentState;
import org.switchyard.as7.extension.services.SwitchYardAdminService;
import org.switchyard.common.camel.SwitchYardCamelContext;
import org.switchyard.config.model.switchyard.SwitchYardModel;
import org.switchyard.deploy.ActivatorLoader;
import org.switchyard.deploy.Component;
import org.switchyard.deploy.ServiceDomainManager;
import org.switchyard.deploy.internal.Deployment;

public class SwitchYardDeployment {
    public static final AttachmentKey<SwitchYardDeployment> ATTACHMENT_KEY = AttachmentKey.create(SwitchYardDeployment.class);
    private final DeploymentUnit _deployUnit;
    private SwitchYardDeploymentState _deploymentState;
    private Deployment _deployment;
    private ServiceDomainManager _domainManager;
    private ServiceDomain _appServiceDomain;
    private NamespaceContextSelector _contextSelector;

    public SwitchYardDeployment(DeploymentUnit deploymentUnit, SwitchYardModel config, ServiceDomainManager domainManager) {
        this._deployUnit = deploymentUnit;
        this._deployment = new Deployment(config);
        this._domainManager = domainManager;
    }

    public void create() {
    }

    public void destroy() {
    }

    public void setNamespaceContextSelector(NamespaceContextSelector contextSelector) {
        this._contextSelector = contextSelector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(List<Component> components) {
        Module module = (Module)this._deployUnit.getAttachment(Attachments.MODULE);
        ClassLoader origCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)module.getClassLoader());
            this.setDeploymentState(SwitchYardDeploymentState.INITIALIZING);
            this._appServiceDomain = this._domainManager.createDomain(this.getName(this._deployment.getConfig()), this._deployment.getConfig());
            SwitchYardCamelContext camelCtx = (SwitchYardCamelContext)this._appServiceDomain.getProperty("CamelContextProperty");
            camelCtx.getExecutorServiceManager().setThreadPoolFactory((ThreadPoolFactory)new JBossThreadPoolFactory(this._contextSelector));
            camelCtx.getWritebleRegistry().put((Object)"org.switchyard.namespaceContextPolicy", (Object)new NamespaceContextPolicy(this._contextSelector));
            List activators = ActivatorLoader.createActivators((ServiceDomain)this._appServiceDomain, components, (List)this._deployment.getActivationTypes());
            this._deployment.init(this._appServiceDomain, activators);
            this.setDeploymentState(SwitchYardDeploymentState.STARTING);
            this._deployment.start();
            this.setDeploymentState(SwitchYardDeploymentState.STARTED);
            this.registerManagementNodes();
        }
        finally {
            Thread.currentThread().setContextClassLoader(origCL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        ClassLoader origCL = Thread.currentThread().getContextClassLoader();
        try {
            Module module = (Module)this._deployUnit.getAttachment(Attachments.MODULE);
            Thread.currentThread().setContextClassLoader((ClassLoader)module.getClassLoader());
            if (this._deploymentState == SwitchYardDeploymentState.STARTED) {
                this._deployment.stop();
                this.setDeploymentState(SwitchYardDeploymentState.STOPPED);
                this.unregisterManagementNodes();
            }
            if (this._deploymentState == SwitchYardDeploymentState.STARTING || this._deploymentState == SwitchYardDeploymentState.STOPPED) {
                this._deployment.destroy();
                this.setDeploymentState(SwitchYardDeploymentState.DESTROYED);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(origCL);
        }
    }

    public void setDeploymentState(SwitchYardDeploymentState deploymentState) {
        this._deploymentState = deploymentState;
    }

    public SwitchYardDeploymentState getDeploymentState() {
        return this._deploymentState;
    }

    public ServiceDomain getDomain() {
        return this._appServiceDomain;
    }

    private void registerManagementNodes() {
        QName applicationName = this._deployment.getName();
        if (applicationName == null) {
            return;
        }
        ServiceController adminService = this._deployUnit.getServiceRegistry().getService(SwitchYardAdminService.SERVICE_NAME);
        if (adminService == null) {
            return;
        }
        BaseSwitchYard switchYard = (BaseSwitchYard)BaseSwitchYard.class.cast(adminService.getValue());
        if (switchYard == null) {
            return;
        }
        ModelNode deployNode = this._deployUnit.createDeploymentSubModel("switchyard", PathElement.pathElement((String)"application", (String)applicationName.toString()));
        Application application = switchYard.getApplication(applicationName);
        if (application == null) {
            return;
        }
        deployNode.set(ModelNodeCreationUtil.createApplicationNode(application));
    }

    private void unregisterManagementNodes() {
        QName applicationName = this._deployment.getName();
        if (applicationName == null) {
            return;
        }
        this._deployUnit.createDeploymentSubModel("switchyard", PathElement.pathElement((String)"application", (String)applicationName.toString())).clear();
    }

    private QName getName(SwitchYardModel config) {
        if (config == null) {
            return null;
        }
        QName name = config.getQName();
        if (name == null && config.getComposite() != null) {
            name = config.getComposite().getQName();
        }
        return name;
    }
}

