/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.deploy.internal;

import java.util.ServiceLoader;
import javax.xml.namespace.QName;
import org.switchyard.ServiceDomain;
import org.switchyard.internal.DefaultServiceRegistry;
import org.switchyard.internal.DomainImpl;
import org.switchyard.internal.LocalExchangeBus;
import org.switchyard.internal.transform.BaseTransformerRegistry;
import org.switchyard.spi.ExchangeBus;
import org.switchyard.spi.ServiceRegistry;
import org.switchyard.transform.TransformerRegistry;

public abstract class AbstractDeployment {
    public static final QName ROOT_DOMAIN = new QName("org.switchyard.domains.root");
    public static final String ENDPOINT_PROVIDER_CLASS_NAME = "org.switchyard.endpoint.provider.class.name";
    public static final String REGISTRY_CLASS_NAME = "org.switchyard.registry.class.name";
    private ServiceDomain _serviceDomain;

    public void init() {
        this.createDomain();
    }

    public abstract void destroy();

    public ServiceDomain getDomain() {
        return this._serviceDomain;
    }

    private void createDomain() {
        String registryClassName = System.getProperty(REGISTRY_CLASS_NAME, DefaultServiceRegistry.class.getName());
        String endpointProviderClassName = System.getProperty(ENDPOINT_PROVIDER_CLASS_NAME, LocalExchangeBus.class.getName());
        try {
            ServiceRegistry registry = AbstractDeployment.getRegistry(registryClassName);
            ExchangeBus endpointProvider = AbstractDeployment.getEndpointProvider(endpointProviderClassName);
            BaseTransformerRegistry transformerRegistry = new BaseTransformerRegistry();
            this._serviceDomain = new DomainImpl(ROOT_DOMAIN, registry, endpointProvider, (TransformerRegistry)transformerRegistry);
        }
        catch (NullPointerException npe) {
            throw new RuntimeException(npe);
        }
    }

    private static ServiceRegistry getRegistry(String registryClass) {
        ServiceLoader<ServiceRegistry> registryServices = ServiceLoader.load(ServiceRegistry.class);
        for (ServiceRegistry serviceRegistry : registryServices) {
            if (!registryClass.equals(serviceRegistry.getClass().getName())) continue;
            return serviceRegistry;
        }
        return null;
    }

    private static ExchangeBus getEndpointProvider(String providerClass) {
        ServiceLoader<ExchangeBus> providerServices = ServiceLoader.load(ExchangeBus.class);
        for (ExchangeBus provider : providerServices) {
            if (!providerClass.equals(provider.getClass().getName())) continue;
            return provider;
        }
        return null;
    }
}

