/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.deploy;

import javax.xml.namespace.QName;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.HandlerChain;
import org.switchyard.ServiceDomain;
import org.switchyard.ServiceReference;
import org.switchyard.deploy.ServiceDomainManager;
import org.switchyard.metadata.ExchangeContract;
import org.switchyard.metadata.ServiceInterface;
import org.switchyard.transform.TransformerRegistry;

class DomainProxy
implements ServiceDomain {
    private ServiceDomain _domain;
    private ServiceDomainManager _domainManager;

    public DomainProxy(ServiceDomain domain, ServiceDomainManager domainManager) {
        this._domain = domain;
        this._domainManager = domainManager;
    }

    public QName getName() {
        return this._domain.getName();
    }

    public ServiceDomain getDomain() {
        return this._domain;
    }

    public ServiceReference getService(QName serviceName) {
        ServiceReference service = this._domain.getService(serviceName);
        if (service == null) {
            service = this._domainManager.findService(serviceName, this._domain);
        }
        return service;
    }

    public Exchange createExchange(ServiceReference service, ExchangeContract contract) {
        return this._domain.createExchange(service, contract);
    }

    public Exchange createExchange(ServiceReference service, ExchangeContract contract, ExchangeHandler handler) {
        return this._domain.createExchange(service, contract, handler);
    }

    public ServiceReference registerService(QName serviceName, ExchangeHandler handler) {
        return this._domain.registerService(serviceName, handler);
    }

    public ServiceReference registerService(QName serviceName, ExchangeHandler handler, ServiceInterface metadata) {
        return this._domain.registerService(serviceName, handler, metadata);
    }

    public TransformerRegistry getTransformerRegistry() {
        return this._domain.getTransformerRegistry();
    }

    public HandlerChain getHandlerChain() {
        return this._domain.getHandlerChain();
    }
}

