/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.deploy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import javax.xml.namespace.QName;
import org.switchyard.ExchangeHandler;
import org.switchyard.ServiceDomain;
import org.switchyard.ServiceReference;
import org.switchyard.common.type.Classes;
import org.switchyard.config.model.domain.HandlerModel;
import org.switchyard.config.model.switchyard.SwitchYardModel;
import org.switchyard.deploy.DomainProxy;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.internal.DefaultServiceRegistry;
import org.switchyard.internal.DomainImpl;
import org.switchyard.internal.LocalExchangeBus;
import org.switchyard.internal.transform.BaseTransformerRegistry;
import org.switchyard.spi.ExchangeBus;
import org.switchyard.spi.ServiceRegistry;
import org.switchyard.transform.TransformerRegistry;

public class ServiceDomainManager {
    public static final QName ROOT_DOMAIN = new QName("org.switchyard.domains.root");
    public static final String BUS_CLASS_NAME = "busProvider";
    public static final String REGISTRY_CLASS_NAME = "registryProvider";
    private List<ServiceDomain> _activeApplicationServiceDomains = Collections.synchronizedList(new ArrayList());

    public ServiceReference findService(QName serviceName, ServiceDomain excludeDomain) {
        if (excludeDomain instanceof DomainProxy) {
            excludeDomain = ((DomainProxy)excludeDomain).getDomain();
        }
        for (ServiceDomain domain : this._activeApplicationServiceDomains) {
            ServiceReference service;
            if (domain == excludeDomain || (service = domain.getService(serviceName)) == null) continue;
            return service;
        }
        return null;
    }

    public static ServiceDomain createDomain() {
        return ServiceDomainManager.createDomain(ROOT_DOMAIN, null);
    }

    public static ServiceDomain createDomain(QName domainName, SwitchYardModel switchyardConfig) {
        ServiceRegistry registry = ServiceDomainManager.getRegistry(DefaultServiceRegistry.class.getName());
        ExchangeBus endpointProvider = ServiceDomainManager.getEndpointProvider(LocalExchangeBus.class.getName());
        BaseTransformerRegistry transformerRegistry = new BaseTransformerRegistry();
        DomainImpl domain = new DomainImpl(domainName, registry, endpointProvider, (TransformerRegistry)transformerRegistry);
        if (switchyardConfig != null) {
            ServiceDomainManager.addHandlersToDomain((ServiceDomain)domain, switchyardConfig);
        }
        return domain;
    }

    public ServiceDomain addApplicationServiceDomain(QName applicationName) {
        return this.addApplicationServiceDomain(applicationName, null);
    }

    public ServiceDomain addApplicationServiceDomain(QName applicationName, SwitchYardModel switchyardConfig) {
        ServiceDomain serviceDomain = ServiceDomainManager.createDomain(applicationName, switchyardConfig);
        this._activeApplicationServiceDomains.add(serviceDomain);
        return new DomainProxy(serviceDomain, this);
    }

    public void removeApplicationServiceDomain(ServiceDomain applicationDomain) {
        if (applicationDomain instanceof DomainProxy) {
            this._activeApplicationServiceDomains.remove(((DomainProxy)applicationDomain).getDomain());
        } else {
            this._activeApplicationServiceDomains.remove(applicationDomain);
        }
    }

    private static ServiceRegistry getRegistry(String registryClass) {
        ServiceRegistry registry = null;
        ServiceLoader<ServiceRegistry> registryServices = ServiceLoader.load(ServiceRegistry.class);
        for (ServiceRegistry serviceRegistry : registryServices) {
            if (!registryClass.equals(serviceRegistry.getClass().getName())) continue;
            registry = serviceRegistry;
            break;
        }
        if (registry != null) {
            return registry;
        }
        throw new SwitchYardException("Unable to load registry provider: " + registryClass);
    }

    private static ExchangeBus getEndpointProvider(String providerClass) {
        ServiceLoader<ExchangeBus> providerServices = ServiceLoader.load(ExchangeBus.class);
        ExchangeBus bus = null;
        for (ExchangeBus provider : providerServices) {
            if (!providerClass.equals(provider.getClass().getName())) continue;
            return provider;
        }
        if (bus != null) {
            return bus;
        }
        throw new SwitchYardException("Unable to load exchange bus provider: " + providerClass);
    }

    private static void addHandlersToDomain(ServiceDomain domain, SwitchYardModel config) {
        if (config.getDomain() != null && config.getDomain().getHandlers() != null) {
            for (HandlerModel handlerConfig : config.getDomain().getHandlers().getHandlers()) {
                Class handlerClass = Classes.forName((String)handlerConfig.getClassName());
                if (handlerClass == null) {
                    throw new SwitchYardException("Handler class not found " + handlerConfig.getClassName());
                }
                if (!ExchangeHandler.class.isAssignableFrom(handlerClass)) {
                    throw new SwitchYardException("Handler " + handlerConfig.getName() + " is not an instance of " + ExchangeHandler.class.getName());
                }
                try {
                    ExchangeHandler handler = (ExchangeHandler)handlerClass.newInstance();
                    domain.getHandlerChain().addFirst(handlerConfig.getName(), handler);
                }
                catch (Exception ex) {
                    throw new SwitchYardException("Failed to initialize handler class " + handlerClass.getName(), (Throwable)ex);
                }
            }
        }
    }
}

