/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.deploy.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.switchyard.ExchangeHandler;
import org.switchyard.Service;
import org.switchyard.ServiceReference;
import org.switchyard.common.type.Classes;
import org.switchyard.config.model.ModelPuller;
import org.switchyard.config.model.composite.BindingModel;
import org.switchyard.config.model.composite.ComponentModel;
import org.switchyard.config.model.composite.ComponentReferenceModel;
import org.switchyard.config.model.composite.ComponentServiceModel;
import org.switchyard.config.model.composite.CompositeReferenceModel;
import org.switchyard.config.model.composite.CompositeServiceModel;
import org.switchyard.config.model.composite.InterfaceModel;
import org.switchyard.config.model.switchyard.SwitchYardModel;
import org.switchyard.config.model.transform.TransformsModel;
import org.switchyard.config.model.validate.ValidatesModel;
import org.switchyard.deploy.Activator;
import org.switchyard.deploy.ServiceHandler;
import org.switchyard.deploy.internal.AbstractDeployment;
import org.switchyard.deploy.internal.Activation;
import org.switchyard.deploy.internal.ServicePolicy;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.extensions.wsdl.WSDLReaderException;
import org.switchyard.extensions.wsdl.WSDLService;
import org.switchyard.metadata.ServiceInterface;
import org.switchyard.metadata.java.JavaService;
import org.switchyard.policy.Policy;

public class Deployment
extends AbstractDeployment {
    private static final String JAVA_INTERFACE = "java";
    private static final String WSDL_INTERFACE = "wsdl";
    private static Logger _log = Logger.getLogger(Deployment.class);
    private Map<String, Activator> _activators = new HashMap<String, Activator>();
    private List<Activation> _services = new LinkedList<Activation>();
    private List<Activation> _serviceBindings = new LinkedList<Activation>();
    private List<Activation> _referenceBindings = new LinkedList<Activation>();

    public Deployment(InputStream configStream) throws IOException {
        super((SwitchYardModel)new ModelPuller().pull(configStream));
    }

    public Deployment(SwitchYardModel configModel) {
        super(configModel);
    }

    @Override
    protected void doInit(List<Activator> activators) {
        _log.debug((Object)("Initializing deployment " + this.getName()));
        this.registerTransformers();
        this.registerValidators();
        if (activators != null) {
            for (Activator activator : activators) {
                Collection<String> activationTypes = activator.getActivationTypes();
                if (activationTypes == null) continue;
                for (String type : activationTypes) {
                    _log.debug((Object)("Registered activation type " + type + " for activator " + activator.getClass() + " on deployment " + this.getName()));
                    this._activators.put(type, activator);
                }
            }
        }
    }

    @Override
    protected void doStart() {
        _log.debug((Object)("Starting deployment " + this.getName()));
        try {
            this.deployReferenceBindings();
            this.deployImplementations();
            this.deployServiceBindings();
        }
        catch (RuntimeException e1) {
            _log.debug((Object)("Undeploying partially deployed artifacts of failed deployment " + this.getConfig().getQName()));
            try {
                this.stop();
            }
            catch (RuntimeException e2) {
                _log.debug((Object)("Failed to properly undeploy a partial/failed deployment " + this.getConfig().getQName()), (Throwable)e2);
            }
            throw e1;
        }
    }

    @Override
    protected void doStop() {
        _log.debug((Object)("Stopping deployment " + this.getName()));
        this.undeployServiceBindings();
        this.undeployImplementations();
        this.undeployReferenceBindings();
        this.undeployAutoRegisteredTransformers();
    }

    @Override
    protected void doDestroy() {
        _log.debug((Object)("Destroying deployment " + this.getName()));
        this._serviceBindings.clear();
        this._services.clear();
        this._referenceBindings.clear();
        this.getValidatorRegistryLoader().unregisterValidators();
        this.getTransformerRegistryLoader().unregisterTransformers();
    }

    public Activator findActivator(String type) throws SwitchYardException {
        if (this._activators.containsKey(type)) {
            return this._activators.get(type);
        }
        if (this.failOnMissingActivator()) {
            throw new SwitchYardException("Activator not found for type: " + type);
        }
        return null;
    }

    private Activator findActivator(ComponentModel component) throws SwitchYardException {
        if (component.getImplementation() == null) {
            throw new SwitchYardException("Component defintion " + component.getName() + " does not included an implementation definition.");
        }
        return this.findActivator(component.getImplementation().getType());
    }

    private void registerTransformers() {
        _log.debug((Object)("Registering configured Transformers for deployment " + this.getName()));
        TransformsModel transforms = this.getConfig().getTransforms();
        this.getTransformerRegistryLoader().registerTransformers(transforms);
        this.fireTransformersRegistered(transforms);
    }

    private void registerValidators() {
        _log.debug((Object)("Registering configured Validators for deployment " + this.getName()));
        ValidatesModel validates = this.getConfig().getValidates();
        this.getValidatorRegistryLoader().registerValidators(validates);
        this.fireValidatorsRegistered(validates);
    }

    private void deployReferenceBindings() {
        _log.debug((Object)("Deploying reference bindings for deployment " + this.getName()));
        for (CompositeReferenceModel reference : this.getConfig().getComposite().getReferences()) {
            for (BindingModel binding : reference.getBindings()) {
                QName refQName = reference.getQName();
                _log.debug((Object)("Deploying binding " + binding.getType() + " for reference " + reference.getQName() + " for deployment " + this.getName()));
                Activator activator = this.findActivator(binding.getType());
                if (activator == null) continue;
                ServiceHandler handler = activator.activateBinding(reference.getQName(), binding);
                Activation activation = new Activation(activator, reference.getQName(), handler);
                ServiceInterface si = this.getCompositeReferenceInterface(reference);
                activation.addService(this.getDomain().registerService(refQName, si, (ExchangeHandler)handler));
                this._referenceBindings.add(activation);
                handler.start();
            }
        }
    }

    private ServiceInterface getCompositeReferenceInterface(CompositeReferenceModel compositeRefModel) {
        ServiceInterface serviceInterface = null;
        if (this.hasCompositeReferenceInterface(compositeRefModel)) {
            serviceInterface = this.loadServiceInterface(compositeRefModel.getInterface());
        } else if (this.hasComponentReferenceInterface(compositeRefModel.getComponentReference())) {
            serviceInterface = this.loadServiceInterface((InterfaceModel)compositeRefModel.getComponentReference().getInterface());
        }
        return serviceInterface;
    }

    private ServiceInterface getCompositeServiceInterface(CompositeServiceModel compositeServiceModel) {
        ServiceInterface serviceInterface = null;
        if (this.hasCompositeServiceInterface(compositeServiceModel)) {
            serviceInterface = this.loadServiceInterface(compositeServiceModel.getInterface());
        } else if (this.hasComponentServiceInterface(compositeServiceModel.getComponentService())) {
            serviceInterface = this.loadServiceInterface((InterfaceModel)compositeServiceModel.getComponentService().getInterface());
        }
        return serviceInterface;
    }

    private boolean hasComponentReferenceInterface(ComponentReferenceModel componentRef) {
        return componentRef != null && componentRef.getInterface() != null;
    }

    private boolean hasCompositeReferenceInterface(CompositeReferenceModel compositeRef) {
        return compositeRef != null && compositeRef.getInterface() != null;
    }

    private boolean hasComponentServiceInterface(ComponentServiceModel componentService) {
        return componentService != null && componentService.getInterface() != null;
    }

    private boolean hasCompositeServiceInterface(CompositeServiceModel compositeService) {
        return compositeService != null && compositeService.getInterface() != null;
    }

    private ServiceInterface getComponentReferenceInterface(ComponentReferenceModel reference) {
        ServiceInterface referenceInterface = null;
        if (reference != null && reference.getInterface() != null) {
            referenceInterface = this.loadServiceInterface((InterfaceModel)reference.getInterface());
        }
        return referenceInterface;
    }

    private ServiceInterface getComponentServiceInterface(ComponentServiceModel service) {
        ServiceInterface serviceInterface = null;
        if (service != null && service.getInterface() != null) {
            serviceInterface = this.loadServiceInterface((InterfaceModel)service.getInterface());
        }
        return serviceInterface;
    }

    private ServiceInterface loadServiceInterface(InterfaceModel intfModel) {
        WSDLService serviceInterface = null;
        if (intfModel != null) {
            if (this.isJavaInterface(intfModel.getType())) {
                String interfaceClass = intfModel.getInterface();
                Class<?> serviceInterfaceType = this.loadClass(interfaceClass);
                if (serviceInterfaceType == null) {
                    throw new SwitchYardException("Failed to load Service interface class '" + interfaceClass + "'.");
                }
                serviceInterface = JavaService.fromClass(serviceInterfaceType);
            } else if (intfModel.getType().equals(WSDL_INTERFACE)) {
                try {
                    serviceInterface = WSDLService.fromWSDL((String)intfModel.getInterface());
                }
                catch (WSDLReaderException wsdlre) {
                    throw new SwitchYardException((Throwable)wsdlre);
                }
            }
        }
        return serviceInterface;
    }

    private boolean isJavaInterface(String type) {
        return type.equals(JAVA_INTERFACE);
    }

    private void deployImplementations() {
        HashMap<ComponentServiceModel, CompositeServiceModel> servicePromotions = new HashMap<ComponentServiceModel, CompositeServiceModel>();
        for (CompositeServiceModel compositeService : this.getConfig().getComposite().getServices()) {
            ComponentServiceModel componentService = compositeService.getComponentService();
            if (componentService == null) continue;
            servicePromotions.put(componentService, compositeService);
        }
        for (ComponentModel component : this.getConfig().getComposite().getComponents()) {
            Activator activator = this.findActivator(component);
            if (activator == null) continue;
            LinkedList<ServiceReference> references = new LinkedList<ServiceReference>();
            for (ComponentReferenceModel reference : component.getReferences()) {
                _log.debug((Object)("Registering reference " + reference.getQName() + " for component " + component.getImplementation().getType() + " for deployment " + this.getName()));
                ServiceInterface refIntf = this.getComponentReferenceInterface(reference);
                this.deployAutoRegisteredTransformers(refIntf);
                references.add(this.getDomain().registerServiceReference(reference.getQName(), refIntf));
            }
            for (ComponentServiceModel service : component.getServices()) {
                _log.debug((Object)("Registering service " + service.getQName() + " for component " + component.getImplementation().getType() + " for deployment " + this.getName()));
                ServiceHandler handler = activator.activateService(service.getQName(), component);
                Activation activation = new Activation(activator, service.getQName(), handler);
                ServiceInterface serviceIntf = this.getComponentServiceInterface(service);
                this.deployAutoRegisteredTransformers(serviceIntf);
                List<Policy> requires = this.getPolicyRequirements(service);
                activation.addService(this.getDomain().registerService(service.getQName(), serviceIntf, (ExchangeHandler)handler, requires));
                activation.addReferences(references);
                CompositeServiceModel promotion = (CompositeServiceModel)servicePromotions.get(service);
                if (promotion != null && !promotion.getQName().equals(service.getQName())) {
                    this.getDomain().registerService(promotion.getQName(), serviceIntf, (ExchangeHandler)handler);
                }
                this._services.add(activation);
                handler.start();
            }
            if (component.getServices().isEmpty()) {
                activator.activateService(null, component);
            }
            this.fireComponentDeployed(component);
        }
    }

    private void deployServiceBindings() {
        _log.debug((Object)("Deploying service bindings for deployment " + this.getName()));
        for (CompositeServiceModel service : this.getConfig().getComposite().getServices()) {
            for (BindingModel binding : service.getBindings()) {
                _log.debug((Object)("Deploying binding " + binding.getType() + " for service " + service.getQName() + " for deployment " + this.getName()));
                Activator activator = this.findActivator(binding.getType());
                if (activator == null) continue;
                ServiceHandler handler = activator.activateBinding(service.getQName(), binding);
                Activation activation = new Activation(activator, service.getQName(), handler);
                activation.addReference(this.getDomain().registerServiceReference(service.getQName(), this.getCompositeServiceInterface(service)));
                this._serviceBindings.add(activation);
                handler.start();
            }
            this.fireServiceDeployed(service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void undeployServiceBindings() {
        _log.debug((Object)("Undeploying service bindings for deployment " + this.getName()));
        LinkedHashSet undeployedServiceNames = new LinkedHashSet();
        try {
            for (Activation activation : this._serviceBindings) {
                activation.getHandler().stop();
                activation.getActivator().deactivateBinding(activation.getName(), activation.getHandler());
                for (ServiceReference reference : activation.getReferences()) {
                    reference.unregister();
                }
            }
        }
        finally {
            this._serviceBindings.clear();
        }
        for (QName serviceName : undeployedServiceNames) {
            this.fireServiceUndeployed(serviceName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void undeployImplementations() {
        _log.debug((Object)("Undeploying services for deployment " + this.getName()));
        LinkedHashSet undeployedServiceNames = new LinkedHashSet();
        try {
            for (Activation activation : this._services) {
                activation.getHandler().stop();
                activation.getActivator().deactivateService(activation.getName(), activation.getHandler());
                for (Service service : activation.getServices()) {
                    service.unregister();
                }
                for (ServiceReference reference : activation.getReferences()) {
                    reference.unregister();
                }
            }
        }
        finally {
            this._services.clear();
        }
        for (QName serviceName : undeployedServiceNames) {
            this.fireComponentUndeployed(serviceName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void undeployReferenceBindings() {
        _log.debug((Object)("Undeploying reference bindings for deployment " + this.getName()));
        try {
            for (Activation activation : this._referenceBindings) {
                activation.getHandler().stop();
                activation.getActivator().deactivateBinding(activation.getName(), activation.getHandler());
                for (Service service : activation.getServices()) {
                    service.unregister();
                }
            }
        }
        finally {
            this._referenceBindings.clear();
        }
    }

    private Class<?> loadClass(String className) {
        return Classes.forName((String)className, this.getClass());
    }

    private List<Policy> getPolicyRequirements(ComponentServiceModel model) {
        LinkedList<Policy> requires = new LinkedList<Policy>();
        for (String policyName : model.getPolicyRequirements()) {
            requires.add(new ServicePolicy(policyName));
        }
        return requires;
    }
}

