/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.deploy.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.switchyard.ExchangeHandler;
import org.switchyard.Service;
import org.switchyard.ServiceReference;
import org.switchyard.common.type.Classes;
import org.switchyard.config.model.ModelPuller;
import org.switchyard.config.model.composite.BindingModel;
import org.switchyard.config.model.composite.ComponentImplementationModel;
import org.switchyard.config.model.composite.ComponentModel;
import org.switchyard.config.model.composite.ComponentReferenceModel;
import org.switchyard.config.model.composite.ComponentServiceModel;
import org.switchyard.config.model.composite.CompositeModel;
import org.switchyard.config.model.composite.CompositeReferenceModel;
import org.switchyard.config.model.composite.CompositeServiceModel;
import org.switchyard.config.model.composite.InterfaceModel;
import org.switchyard.config.model.switchyard.EsbInterfaceModel;
import org.switchyard.config.model.switchyard.SwitchYardModel;
import org.switchyard.config.model.transform.TransformsModel;
import org.switchyard.config.model.validate.ValidatesModel;
import org.switchyard.deploy.Activator;
import org.switchyard.deploy.Binding;
import org.switchyard.deploy.Implementation;
import org.switchyard.deploy.ServiceHandler;
import org.switchyard.deploy.event.ApplicationDeployedEvent;
import org.switchyard.deploy.event.ApplicationUndeployedEvent;
import org.switchyard.deploy.internal.AbstractDeployment;
import org.switchyard.deploy.internal.Activation;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.extensions.wsdl.WSDLReaderException;
import org.switchyard.extensions.wsdl.WSDLService;
import org.switchyard.internal.ServiceReferenceImpl;
import org.switchyard.metadata.InOnlyOperation;
import org.switchyard.metadata.InOnlyService;
import org.switchyard.metadata.InOutOperation;
import org.switchyard.metadata.InOutService;
import org.switchyard.metadata.Registrant;
import org.switchyard.metadata.ServiceInterface;
import org.switchyard.metadata.java.JavaService;
import org.switchyard.policy.Policy;
import org.switchyard.policy.PolicyFactory;

public class Deployment
extends AbstractDeployment {
    private static Logger _log = Logger.getLogger(Deployment.class);
    private Map<String, Activator> _activators = new HashMap<String, Activator>();
    private List<Activation> _services = new LinkedList<Activation>();
    private List<Activation> _serviceBindings = new LinkedList<Activation>();
    private List<Activation> _referenceBindings = new LinkedList<Activation>();

    public Deployment(InputStream configStream) throws IOException {
        super((SwitchYardModel)new ModelPuller().pull(configStream));
    }

    public Deployment(SwitchYardModel configModel) {
        super(configModel);
    }

    @Override
    protected void doInit(List<Activator> activators) {
        _log.debug((Object)("Initializing deployment " + this.getName()));
        this.registerTransformers();
        this.registerValidators();
        if (activators != null) {
            for (Activator activator : activators) {
                Collection<String> activationTypes = activator.getActivationTypes();
                if (activationTypes == null) continue;
                for (String type : activationTypes) {
                    _log.debug((Object)("Registered activation type " + type + " for activator " + activator.getClass() + " on deployment " + this.getName()));
                    this._activators.put(type, activator);
                }
            }
        }
        this.getDomain().getEventPublisher().publish((EventObject)new ApplicationDeployedEvent(this));
    }

    @Override
    public void start() {
        _log.debug((Object)("Starting deployment " + this.getName()));
        try {
            this.deployReferenceBindings();
            this.deployImplementations();
            this.deployServiceBindings();
        }
        catch (RuntimeException e1) {
            _log.debug((Object)("Undeploying partially deployed artifacts of failed deployment " + this.getConfig().getQName()));
            try {
                this.stop();
            }
            catch (RuntimeException e2) {
                _log.debug((Object)("Failed to properly undeploy a partial/failed deployment " + this.getConfig().getQName()), (Throwable)e2);
            }
            throw e1;
        }
    }

    @Override
    public void stop() {
        _log.debug((Object)("Stopping deployment " + this.getName()));
        this.undeployServiceBindings();
        this.undeployImplementations();
        this.undeployReferenceBindings();
    }

    @Override
    public void destroy() {
        _log.debug((Object)("Destroying deployment " + this.getName()));
        this._serviceBindings.clear();
        this._services.clear();
        this._referenceBindings.clear();
        this.getValidatorRegistryLoader().unregisterValidators();
        this.getTransformerRegistryLoader().unregisterTransformers();
        this.getDomain().getEventPublisher().publish((EventObject)new ApplicationUndeployedEvent(this));
        this.getDomain().destroy();
    }

    public Activator findActivator(String type) throws SwitchYardException {
        if (this._activators.containsKey(type)) {
            return this._activators.get(type);
        }
        if (this.failOnMissingActivator()) {
            throw new SwitchYardException("Activator not found for type: " + type);
        }
        return null;
    }

    public List<String> getActivationTypes() {
        HashSet<String> types = new HashSet<String>();
        CompositeModel composite = this.getConfig().getComposite();
        for (CompositeReferenceModel reference : composite.getReferences()) {
            for (BindingModel binding : reference.getBindings()) {
                types.add(binding.getType());
            }
        }
        for (CompositeServiceModel service : composite.getServices()) {
            for (BindingModel binding : service.getBindings()) {
                types.add(binding.getType());
            }
        }
        for (ComponentModel component : composite.getComponents()) {
            if (component.getImplementation() == null) continue;
            types.add(component.getImplementation().getType());
        }
        return new ArrayList<String>(types);
    }

    private Activator findActivator(ComponentModel component) throws SwitchYardException {
        if (component.getImplementation() == null) {
            throw new SwitchYardException("Component defintion " + component.getName() + " does not included an implementation definition.");
        }
        return this.findActivator(component.getImplementation().getType());
    }

    private void registerTransformers() {
        _log.debug((Object)("Registering configured Transformers for deployment " + this.getName()));
        TransformsModel transforms = this.getConfig().getTransforms();
        this.getTransformerRegistryLoader().registerTransformers(transforms);
    }

    private void registerValidators() {
        _log.debug((Object)("Registering configured Validators for deployment " + this.getName()));
        ValidatesModel validates = this.getConfig().getValidates();
        this.getValidatorRegistryLoader().registerValidators(validates);
    }

    private void deployReferenceBindings() {
        _log.debug((Object)("Deploying reference bindings for deployment " + this.getName()));
        for (CompositeReferenceModel reference : this.getConfig().getComposite().getReferences()) {
            for (BindingModel binding : reference.getBindings()) {
                QName refQName = reference.getQName();
                _log.debug((Object)("Deploying binding " + binding.getType() + " for reference " + reference.getQName() + " for deployment " + this.getName()));
                Activator activator = this.findActivator(binding.getType());
                if (activator == null) continue;
                ServiceHandler handler = activator.activateBinding(reference.getQName(), binding);
                Activation activation = new Activation(activator, reference.getQName(), handler);
                ServiceInterface si = this.getCompositeReferenceInterface(reference);
                Binding bindingMetadata = new Binding(binding);
                this.validateServiceRegistration(refQName);
                Service svc = this.getDomain().registerService(refQName, si, (ExchangeHandler)handler, null, (Registrant)bindingMetadata);
                activation.addService(svc);
                this._referenceBindings.add(activation);
                handler.start();
            }
        }
    }

    private ServiceInterface getCompositeReferenceInterface(CompositeReferenceModel compositeRefModel) {
        ServiceInterface serviceInterface = null;
        if (this.hasCompositeReferenceInterface(compositeRefModel)) {
            serviceInterface = this.loadServiceInterface(compositeRefModel.getInterface());
        } else if (this.hasComponentReferenceInterface(compositeRefModel.getComponentReference())) {
            serviceInterface = this.loadServiceInterface(compositeRefModel.getComponentReference().getInterface());
        }
        return serviceInterface;
    }

    private ServiceInterface getCompositeServiceInterface(CompositeServiceModel compositeServiceModel) {
        ServiceInterface serviceInterface = null;
        if (this.hasCompositeServiceInterface(compositeServiceModel)) {
            serviceInterface = this.loadServiceInterface(compositeServiceModel.getInterface());
        } else if (this.hasComponentServiceInterface(compositeServiceModel.getComponentService())) {
            serviceInterface = this.loadServiceInterface(compositeServiceModel.getComponentService().getInterface());
        }
        return serviceInterface;
    }

    private boolean hasComponentReferenceInterface(ComponentReferenceModel componentRef) {
        return componentRef != null && componentRef.getInterface() != null;
    }

    private boolean hasCompositeReferenceInterface(CompositeReferenceModel compositeRef) {
        return compositeRef != null && compositeRef.getInterface() != null;
    }

    private boolean hasComponentServiceInterface(ComponentServiceModel componentService) {
        return componentService != null && componentService.getInterface() != null;
    }

    private boolean hasCompositeServiceInterface(CompositeServiceModel compositeService) {
        return compositeService != null && compositeService.getInterface() != null;
    }

    private ServiceInterface getComponentReferenceInterface(ComponentReferenceModel reference) {
        ServiceInterface referenceInterface = null;
        if (reference != null && reference.getInterface() != null) {
            referenceInterface = this.loadServiceInterface(reference.getInterface());
        }
        return referenceInterface;
    }

    private ServiceInterface getComponentServiceInterface(ComponentServiceModel service) {
        ServiceInterface serviceInterface = null;
        if (service != null && service.getInterface() != null) {
            serviceInterface = this.loadServiceInterface(service.getInterface());
        }
        return serviceInterface;
    }

    private ServiceInterface loadServiceInterface(InterfaceModel intfModel) {
        Object serviceInterface = null;
        if (intfModel != null) {
            if (this.isJavaInterface(intfModel.getType())) {
                String interfaceClass = intfModel.getInterface();
                Class<?> serviceInterfaceType = this.loadClass(interfaceClass);
                if (serviceInterfaceType == null) {
                    throw new SwitchYardException("Failed to load Service interface class '" + interfaceClass + "'.");
                }
                serviceInterface = JavaService.fromClass(serviceInterfaceType);
            } else if ("wsdl".equals(intfModel.getType())) {
                try {
                    serviceInterface = WSDLService.fromWSDL((String)intfModel.getInterface());
                }
                catch (WSDLReaderException wsdlre) {
                    throw new SwitchYardException((Throwable)wsdlre);
                }
            } else if ("esb".equals(intfModel.getType())) {
                EsbInterfaceModel esbIntf = (EsbInterfaceModel)intfModel;
                this.validateEsbInterface(esbIntf);
                serviceInterface = esbIntf.getOutputType() == null ? new InOnlyService(new InOnlyOperation("", esbIntf.getInputType())) : new InOutService(new InOutOperation("", esbIntf.getInputType(), esbIntf.getOutputType(), esbIntf.getFaultType()));
            }
        }
        return serviceInterface;
    }

    private void validateEsbInterface(EsbInterfaceModel esbIntf) {
        if (esbIntf.getInputType() == null) {
            throw new SwitchYardException("inputType required on ESB interface definition: " + esbIntf);
        }
        if (esbIntf.getFaultType() != null && esbIntf.getOutputType() == null) {
            throw new SwitchYardException("faultType must be acommpanied by outputType in ESB interface: " + esbIntf);
        }
    }

    private boolean isJavaInterface(String type) {
        return "java".equals(type);
    }

    private void deployImplementations() {
        HashMap<ComponentServiceModel, CompositeServiceModel> servicePromotions = new HashMap<ComponentServiceModel, CompositeServiceModel>();
        for (CompositeServiceModel compositeService : this.getConfig().getComposite().getServices()) {
            ComponentServiceModel componentService = compositeService.getComponentService();
            if (componentService == null) continue;
            servicePromotions.put(componentService, compositeService);
        }
        for (ComponentModel component : this.getConfig().getComposite().getComponents()) {
            Activator activator = this.findActivator(component);
            if (activator == null) continue;
            List<Policy> requiresImpl = null;
            try {
                requiresImpl = this.getPolicyRequirements(component.getImplementation());
            }
            catch (Exception e) {
                throw new SwitchYardException((Throwable)e);
            }
            Implementation impl = new Implementation(component.getImplementation());
            LinkedList<ServiceReference> references = new LinkedList<ServiceReference>();
            for (ComponentReferenceModel reference : component.getReferences()) {
                _log.debug((Object)("Registering reference " + reference.getQName() + " for component " + component.getImplementation().getType() + " for deployment " + this.getName()));
                List<Policy> requires = null;
                try {
                    requires = this.getPolicyRequirements(reference);
                }
                catch (Exception e) {
                    throw new SwitchYardException("Unable to collect requirements for " + reference, (Throwable)e);
                }
                this.validatePolicy(requires, requiresImpl);
                ServiceInterface refIntf = this.getComponentReferenceInterface(reference);
                ServiceReference svcRef = this.getDomain().registerServiceReference(reference.getQName(), refIntf, null, null, requires, (Registrant)impl);
                references.add(svcRef);
            }
            if (component.getServices().size() > 1) {
                throw new SwitchYardException("Multiple services in the Component '" + component.getName() + "' - Just one service is allowed");
            }
            if (component.getServices().size() == 1) {
                ComponentServiceModel service = (ComponentServiceModel)component.getServices().get(0);
                _log.debug((Object)("Registering service " + service.getQName() + " for component " + component.getImplementation().getType() + " for deployment " + this.getName()));
                List<Policy> requires = null;
                try {
                    requires = this.getPolicyRequirements(service);
                    this.validatePolicy(requires, requiresImpl);
                }
                catch (Exception e) {
                    throw new SwitchYardException((Throwable)e);
                }
                requires.addAll(requiresImpl);
                ServiceHandler handler = activator.activateService(service.getQName(), component);
                Activation activation = new Activation(activator, service.getQName(), handler);
                ServiceInterface serviceIntf = this.getComponentServiceInterface(service);
                Service svc = this.getDomain().registerService(service.getQName(), serviceIntf, (ExchangeHandler)handler, requires, (Registrant)impl);
                activation.addService(svc);
                activation.addReferences(references);
                CompositeServiceModel promotion = (CompositeServiceModel)servicePromotions.get(service);
                if (promotion != null && !promotion.getQName().equals(service.getQName())) {
                    this.validateServiceRegistration(promotion.getQName());
                    Service promotedService = this.getDomain().registerService(promotion.getQName(), serviceIntf, (ExchangeHandler)handler);
                    activation.addPromotion(promotedService);
                }
                this._services.add(activation);
                handler.start();
                continue;
            }
            activator.activateService(null, component);
        }
    }

    private void deployServiceBindings() {
        _log.debug((Object)("Deploying service bindings for deployment " + this.getName()));
        for (CompositeServiceModel service : this.getConfig().getComposite().getServices()) {
            ServiceReference reference = this.getDomain().registerServiceReference(service.getQName(), this.getCompositeServiceInterface(service));
            for (BindingModel binding : service.getBindings()) {
                _log.debug((Object)("Deploying binding " + binding.getType() + " for service " + service.getQName() + " for deployment " + this.getName()));
                Activator activator = this.findActivator(binding.getType());
                if (activator == null) continue;
                Binding bindingMetadata = new Binding(binding);
                ((ServiceReferenceImpl)reference).setConsumerMetadata((Registrant)bindingMetadata);
                ServiceHandler handler = activator.activateBinding(service.getQName(), binding);
                Activation activation = new Activation(activator, service.getQName(), handler);
                activation.addReference(reference);
                this._serviceBindings.add(activation);
                handler.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void undeployServiceBindings() {
        _log.debug((Object)("Undeploying service bindings for deployment " + this.getName()));
        try {
            for (Activation activation : this._serviceBindings) {
                activation.getHandler().stop();
                activation.getActivator().deactivateBinding(activation.getName(), activation.getHandler());
                for (ServiceReference reference : activation.getReferences()) {
                    reference.unregister();
                }
            }
        }
        finally {
            this._serviceBindings.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void undeployImplementations() {
        _log.debug((Object)("Undeploying services for deployment " + this.getName()));
        try {
            for (Activation activation : this._services) {
                activation.getHandler().stop();
                activation.getActivator().deactivateService(activation.getName(), activation.getHandler());
                for (Service service : activation.getServices()) {
                    service.unregister();
                }
                for (ServiceReference reference : activation.getReferences()) {
                    reference.unregister();
                }
                for (Service service : activation.getPromotions()) {
                    service.unregister();
                }
            }
        }
        finally {
            this._services.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void undeployReferenceBindings() {
        _log.debug((Object)("Undeploying reference bindings for deployment " + this.getName()));
        try {
            for (Activation activation : this._referenceBindings) {
                activation.getHandler().stop();
                activation.getActivator().deactivateBinding(activation.getName(), activation.getHandler());
                for (Service service : activation.getServices()) {
                    service.unregister();
                }
            }
        }
        finally {
            this._referenceBindings.clear();
        }
    }

    private Class<?> loadClass(String className) {
        return Classes.forName((String)className, this.getClass());
    }

    private List<Policy> getPolicyRequirements(ComponentServiceModel serviceModel) throws Exception {
        LinkedList<Policy> requires = new LinkedList<Policy>();
        for (String policyName : serviceModel.getPolicyRequirements()) {
            requires.add(PolicyFactory.getPolicy((String)policyName));
        }
        return requires;
    }

    private List<Policy> getPolicyRequirements(ComponentImplementationModel implModel) throws Exception {
        LinkedList<Policy> requires = new LinkedList<Policy>();
        for (String policyName : implModel.getPolicyRequirements()) {
            requires.add(PolicyFactory.getPolicy((String)policyName));
        }
        return requires;
    }

    private List<Policy> getPolicyRequirements(ComponentReferenceModel referenceModel) throws Exception {
        LinkedList<Policy> requires = new LinkedList<Policy>();
        for (String policyName : referenceModel.getPolicyRequirements()) {
            requires.add(PolicyFactory.getPolicy((String)policyName));
        }
        return requires;
    }

    private void validatePolicy(List<Policy> interaction, List<Policy> implementation) {
        int j;
        Policy required;
        int i;
        for (i = 0; interaction != null && i < interaction.size(); ++i) {
            if (interaction.get(i).getType() != Policy.PolicyType.INTERACTION) {
                throw new SwitchYardException("Policy '" + interaction.get(i) + "' is not interaction policy, but " + interaction.get(i).getType() + ".");
            }
            required = interaction.get(i).getPolicyDependency();
            if (required != null) {
                if (required.getType() == Policy.PolicyType.INTERACTION && !interaction.contains(required)) {
                    throw new SwitchYardException("Interaction Policy '" + interaction.get(i) + "' should be requested with '" + required);
                }
                if (required.getType() == Policy.PolicyType.IMPLEMENTATION && !implementation.contains(required)) {
                    throw new SwitchYardException("Interaction Policy '" + interaction.get(i) + "' requires '" + required + "' Implementation Policy, but it does not exist. " + implementation);
                }
            }
            for (j = i + 1; j < interaction.size(); ++j) {
                if (interaction.get(i).isCompatibleWith(interaction.get(j))) continue;
                throw new SwitchYardException("Interaction Policy '" + interaction.get(i) + "' and '" + interaction.get(j) + " are not compatible.");
            }
        }
        for (i = 0; implementation != null && i < implementation.size(); ++i) {
            if (implementation.get(i).getType() != Policy.PolicyType.IMPLEMENTATION) {
                throw new SwitchYardException("Policy '" + implementation.get(i) + "' is not implementation policy, but " + implementation.get(i).getType() + ".");
            }
            required = implementation.get(i).getPolicyDependency();
            if (required != null) {
                if (required.getType() == Policy.PolicyType.IMPLEMENTATION && !implementation.contains(required)) {
                    throw new SwitchYardException("Implementation Policy '" + implementation.get(i) + "' should be requested with '" + required);
                }
                if (required.getType() == Policy.PolicyType.INTERACTION && !interaction.contains(required)) {
                    throw new SwitchYardException("Implementation Policy '" + implementation.get(i) + "' requires '" + required + "' Interaction Policy, but it does not exist. " + interaction);
                }
            }
            for (j = i + 1; j < implementation.size(); ++j) {
                if (implementation.get(i).isCompatibleWith(implementation.get(j))) continue;
                throw new SwitchYardException("Implementation Policy '" + implementation.get(i) + "' and '" + implementation.get(j) + " are not compatible.");
            }
            for (j = 0; interaction != null && j < interaction.size(); ++j) {
                if (implementation.get(i).isCompatibleWith(interaction.get(j))) continue;
                throw new SwitchYardException("Implementation Policy '" + implementation.get(i) + "' and Interaciton Policy'" + interaction.get(j) + " are not compatible.");
            }
        }
    }

    private void validateServiceRegistration(QName name) {
        for (ComponentModel component : this.getConfig().getComposite().getComponents()) {
            for (ComponentServiceModel service : component.getServices()) {
                System.out.println(service.getQName());
                System.out.println(name);
                if (!service.getQName().equals(name)) continue;
                throw new SwitchYardException("Service registration with name " + name + " hides " + service);
            }
        }
    }
}

