/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.deploy;

import java.util.HashMap;
import javax.xml.namespace.QName;
import org.switchyard.BaseDeployMessages;
import org.switchyard.ServiceDomain;
import org.switchyard.bus.camel.CamelExchangeBus;
import org.switchyard.common.camel.SwitchYardCamelContext;
import org.switchyard.config.model.domain.DomainModel;
import org.switchyard.config.model.domain.SecuritiesModel;
import org.switchyard.config.model.domain.SecurityModel;
import org.switchyard.config.model.property.PropertiesModel;
import org.switchyard.config.model.property.PropertyModel;
import org.switchyard.config.model.switchyard.SwitchYardModel;
import org.switchyard.internal.DefaultServiceRegistry;
import org.switchyard.internal.DomainImpl;
import org.switchyard.internal.EventManager;
import org.switchyard.internal.transform.BaseTransformerRegistry;
import org.switchyard.internal.validate.BaseValidatorRegistry;
import org.switchyard.security.service.DefaultServiceDomainSecurity;
import org.switchyard.security.service.DefaultServiceSecurity;
import org.switchyard.security.service.ServiceDomainSecurity;
import org.switchyard.security.system.SystemSecurity;
import org.switchyard.spi.ExchangeBus;
import org.switchyard.spi.ServiceRegistry;
import org.switchyard.transform.TransformerRegistry;
import org.switchyard.validate.ValidatorRegistry;

public class ServiceDomainManager {
    public static final QName ROOT_DOMAIN = new QName("org.switchyard.domains.root");
    private ServiceRegistry _registry = new DefaultServiceRegistry();
    private EventManager _eventManager = new EventManager();
    private final SystemSecurity _systemSecurity;

    public ServiceDomainManager() {
        this(SystemSecurity.DEFAULT);
    }

    public ServiceDomainManager(SystemSecurity systemSecurity) {
        this._systemSecurity = systemSecurity;
    }

    public ServiceDomain createDomain() {
        return this.createDomain(ROOT_DOMAIN, null);
    }

    public ServiceDomain createDomain(QName domainName, SwitchYardModel switchyardConfig) {
        BaseTransformerRegistry transformerRegistry = new BaseTransformerRegistry();
        BaseValidatorRegistry validatorRegistry = new BaseValidatorRegistry();
        SwitchYardCamelContext camelContext = new SwitchYardCamelContext();
        CamelExchangeBus bus = new CamelExchangeBus(camelContext);
        ServiceDomainSecurity serviceDomainSecurity = this.getServiceDomainSecurity(switchyardConfig);
        DomainImpl domain = new DomainImpl(domainName, this._registry, (ExchangeBus)bus, (TransformerRegistry)transformerRegistry, (ValidatorRegistry)validatorRegistry, this._eventManager, serviceDomainSecurity);
        camelContext.setServiceDomain((ServiceDomain)domain);
        PropertiesModel properties = this.getProperties(switchyardConfig);
        if (properties != null) {
            for (PropertyModel property : properties.getProperties()) {
                domain.setProperty(property.getName(), (Object)property.getValue());
            }
        }
        domain.init();
        return domain;
    }

    public EventManager getEventManager() {
        return this._eventManager;
    }

    private ServiceDomainSecurity getServiceDomainSecurity(SwitchYardModel switchyard) {
        SecuritiesModel securities;
        DomainModel domain;
        HashMap<String, DefaultServiceSecurity> serviceSecurities = new HashMap<String, DefaultServiceSecurity>();
        if (switchyard != null && (domain = switchyard.getDomain()) != null && (securities = domain.getSecurities()) != null) {
            for (SecurityModel security : securities.getSecurities()) {
                if (security == null) continue;
                PropertiesModel properties = security.getProperties();
                DefaultServiceSecurity value = new DefaultServiceSecurity().setName(security.getName()).setCallbackHandler(security.getCallbackHandler(this.getClass().getClassLoader())).setProperties(properties != null ? properties.toMap() : null).setRolesAllowed(security.getRolesAllowed()).setRunAs(security.getRunAs()).setSecurityDomain(security.getSecurityDomain());
                String key = value.getName();
                if (!serviceSecurities.containsKey(key)) {
                    serviceSecurities.put(key, value);
                    continue;
                }
                throw BaseDeployMessages.MESSAGES.duplicateSecurityConfigurationNames(key);
            }
        }
        return new DefaultServiceDomainSecurity(serviceSecurities, this._systemSecurity);
    }

    private PropertiesModel getProperties(SwitchYardModel config) {
        if (config == null || config.getDomain() == null) {
            return null;
        }
        return config.getDomain().getProperties();
    }
}

