/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.deploy;

import javax.xml.namespace.QName;
import org.switchyard.ServiceReference;

public final class ComponentNames {
    private ComponentNames() {
    }

    public static QName qualify(QName componentName, QName referenceName) {
        return ComponentNames.qualify(componentName.getLocalPart(), referenceName.getLocalPart(), componentName.getNamespaceURI());
    }

    public static QName qualify(String componentName, String referenceName, String namespaceURI) {
        return new QName(namespaceURI, componentName + "/" + referenceName);
    }

    public static QName unqualify(ServiceReference reference) {
        return ComponentNames.unqualify(reference.getName());
    }

    public static QName unqualify(QName refName) {
        if (refName.getLocalPart().contains("/")) {
            String name = refName.getLocalPart().split("/")[1];
            refName = new QName(refName.getNamespaceURI(), name);
        }
        return refName;
    }

    public static QName componentName(QName refName) {
        if (refName.getLocalPart().contains("/")) {
            String name = refName.getLocalPart().split("/")[0];
            return new QName(refName.getNamespaceURI(), name);
        }
        return null;
    }
}

