/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bean;

import java.lang.reflect.InvocationTargetException;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.ExchangePattern;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.component.bean.BeanComponentException;
import org.switchyard.component.bean.BeanServiceMetadata;
import org.switchyard.component.bean.Invocation;
import org.switchyard.component.bean.deploy.BeanDeploymentMetaData;
import org.switchyard.exception.SwitchYardException;

public class ServiceProxyHandler
implements ExchangeHandler {
    private Object _serviceBean;
    private BeanServiceMetadata _serviceMetadata;
    private BeanDeploymentMetaData _beanDeploymentMetaData;

    public ServiceProxyHandler(Object serviceBean, BeanServiceMetadata serviceMetadata, BeanDeploymentMetaData beanDeploymentMetaData) {
        this._serviceBean = serviceBean;
        this._serviceMetadata = serviceMetadata;
        this._beanDeploymentMetaData = beanDeploymentMetaData;
    }

    public void handleMessage(Exchange exchange) throws HandlerException {
        this.handle(exchange);
    }

    public void handleFault(Exchange exchange) {
    }

    private void handle(Exchange exchange) throws BeanComponentException {
        Invocation invocation = this._serviceMetadata.getInvocation(exchange);
        if (invocation != null) {
            try {
                if (exchange.getContract().getServiceOperation().getExchangePattern() == ExchangePattern.IN_OUT) {
                    Object responseObject = invocation.getMethod().invoke(this._serviceBean, invocation.getArgs());
                    Message message = exchange.createMessage();
                    message.setContent(responseObject);
                    exchange.send(message);
                }
                invocation.getMethod().invoke(this._serviceBean, invocation.getArgs());
            }
            catch (IllegalAccessException e) {
                throw new BeanComponentException("Cannot invoke operation '" + invocation.getMethod().getName() + "' on bean component '" + this._serviceBean.getClass().getName() + "'.", e);
            }
            catch (InvocationTargetException e) {
                throw new BeanComponentException("Invocation of operation '" + invocation.getMethod().getName() + "' on bean component '" + this._serviceBean.getClass().getName() + "' failed with exception.  See attached cause.", e);
            }
        } else {
            throw new SwitchYardException("Unexpected error.  BeanServiceMetadata should return an Invocation instance, or throw a BeanComponentException.");
        }
    }
}

