/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ProcessBean;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.switchyard.component.bean.ClientProxyBean;
import org.switchyard.component.bean.Reference;
import org.switchyard.component.bean.Service;
import org.switchyard.component.bean.deploy.BeanDeploymentMetaData;
import org.switchyard.component.bean.deploy.BeanDeploymentMetaDataCDIBean;
import org.switchyard.component.bean.deploy.CDIBeanServiceDescriptor;

@ApplicationScoped
public class SwitchYardCDIServiceDiscovery
implements Extension {
    private static Logger _logger = Logger.getLogger(SwitchYardCDIServiceDiscovery.class);
    private BeanDeploymentMetaData _beanDeploymentMetaData;
    private List<ClientProxyBean> _createdProxyBeans = new ArrayList<ClientProxyBean>();

    public void beforeBeanDiscovery(@Observes BeforeBeanDiscovery beforeEvent) {
        this._beanDeploymentMetaData = new BeanDeploymentMetaData();
        this._beanDeploymentMetaData.setDeploymentClassLoader(Thread.currentThread().getContextClassLoader());
    }

    public void processBean(@Observes ProcessBean processBean, BeanManager beanManager) {
        Bean bean = processBean.getBean();
        Set injectionPoints = bean.getInjectionPoints();
        for (InjectionPoint injectionPoint : injectionPoints) {
            for (Annotation qualifier : injectionPoint.getQualifiers()) {
                Class<?> memberType;
                Member member;
                if (!Reference.class.isAssignableFrom(qualifier.annotationType()) || !((member = injectionPoint.getMember()) instanceof Field) || !(memberType = ((Field)member).getType()).isInterface()) continue;
                this.addInjectableClientProxyBean((Field)member, (Reference)qualifier, injectionPoint.getQualifiers(), beanManager);
            }
        }
        if (this.isServiceBean(bean)) {
            _logger.debug((Object)("Adding ServiceDescriptor for bean " + bean.getBeanClass().getName()));
            this._beanDeploymentMetaData.addServiceDescriptor(new CDIBeanServiceDescriptor(bean, beanManager, this._beanDeploymentMetaData));
        }
        this._beanDeploymentMetaData.addDeploymentClass(bean.getBeanClass());
    }

    public void afterBeanDiscovery(@Observes AfterBeanDiscovery afterEvent) {
        for (ClientProxyBean proxyBean : this._createdProxyBeans) {
            _logger.debug((Object)("Adding ClientProxyBean for bean Service " + proxyBean.getServiceQName() + ".  Service Interface type is " + proxyBean.getServiceInterface().getName()));
            afterEvent.addBean((Bean)proxyBean);
            this._beanDeploymentMetaData.addClientProxy(proxyBean);
        }
        afterEvent.addBean((Bean)new BeanDeploymentMetaDataCDIBean(this._beanDeploymentMetaData));
    }

    private void addInjectableClientProxyBean(Field injectionPointField, Reference serviceReference, Set<Annotation> qualifiers, BeanManager beanManager) {
        QName serviceQName = this.toServiceQName(injectionPointField.getType());
        this.addClientProxyBean(serviceQName, injectionPointField.getType(), qualifiers);
    }

    private void addClientProxyBean(QName serviceQName, Class<?> beanClass, Set<Annotation> qualifiers) {
        for (ClientProxyBean clientProxyBean : this._createdProxyBeans) {
            if (!serviceQName.equals(clientProxyBean.getServiceQName()) || beanClass != clientProxyBean.getBeanClass()) continue;
            return;
        }
        ClientProxyBean clientProxyBean = new ClientProxyBean(serviceQName, beanClass, qualifiers, this._beanDeploymentMetaData);
        this._createdProxyBeans.add(clientProxyBean);
    }

    private boolean isServiceBean(Bean<?> bean) {
        Class beanClass = bean.getBeanClass();
        return Modifier.isPublic(beanClass.getModifiers()) && beanClass.isAnnotationPresent(Service.class);
    }

    private QName toServiceQName(Class<?> serviceType) {
        return new QName(serviceType.getSimpleName());
    }
}

