/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bean.deploy;

import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.xml.namespace.QName;
import org.switchyard.ExchangeHandler;
import org.switchyard.component.bean.BeanServiceMetadata;
import org.switchyard.component.bean.Service;
import org.switchyard.component.bean.ServiceProxyHandler;
import org.switchyard.component.bean.deploy.BeanDeploymentMetaData;
import org.switchyard.component.bean.deploy.ServiceDescriptor;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.metadata.ServiceInterface;
import org.switchyard.metadata.java.JavaService;

public class CDIBeanServiceDescriptor
implements ServiceDescriptor {
    private QName _serviceName;
    private Bean _bean;
    private BeanServiceMetadata _serviceMetadata;
    private BeanManager _beanManager;
    private BeanDeploymentMetaData _beanDeploymentMetaData;

    public CDIBeanServiceDescriptor(Bean bean, BeanManager beanManager, BeanDeploymentMetaData beanDeploymentMetaData) {
        Class<?> serviceInterface = this.getServiceInterface(bean);
        this._bean = bean;
        this._beanManager = beanManager;
        this._serviceName = new QName(serviceInterface.getSimpleName());
        this._serviceMetadata = new BeanServiceMetadata(serviceInterface);
        this._beanDeploymentMetaData = beanDeploymentMetaData;
    }

    @Override
    public QName getServiceName() {
        return this._serviceName;
    }

    public BeanServiceMetadata getServiceMetadata() {
        return this._serviceMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExchangeHandler getHandler() {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this._beanDeploymentMetaData.getDeploymentClassLoader());
            CreationalContext creationalContext = this._beanManager.createCreationalContext((Contextual)this._bean);
            Object beanRef = this._beanManager.getReference(this._bean, Object.class, creationalContext);
            ServiceProxyHandler serviceProxyHandler = new ServiceProxyHandler(beanRef, this._serviceMetadata, this._beanDeploymentMetaData);
            return serviceProxyHandler;
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    @Override
    public ServiceInterface getInterface() {
        return JavaService.fromClass(this._serviceMetadata.getServiceClass());
    }

    private Class<?> getServiceInterface(Bean bean) {
        return CDIBeanServiceDescriptor.getServiceInterface(bean.getBeanClass());
    }

    protected static Class<?> getServiceInterface(Class<?> beanClass) {
        Service serviceAnnotation = beanClass.getAnnotation(Service.class);
        Class<?> serviceInterface = serviceAnnotation.value();
        if (serviceInterface == null) {
            throw new SwitchYardException("Unexpected exception.  The @Service annotation requires a Service interface Class value to be defined, yet the annotation has no value.");
        }
        if (!serviceInterface.isInterface()) {
            throw new SwitchYardException("Invalid @Service specification @Service(" + serviceInterface.getName() + ".class).  @Service interface Class must be a Java Interface.  Cannot be a concrete implementation.");
        }
        return serviceInterface;
    }
}

