/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bean.internal;

import java.util.List;
import javax.xml.namespace.QName;
import org.switchyard.ExchangeHandler;
import org.switchyard.ServiceDomain;
import org.switchyard.ServiceReference;
import org.switchyard.component.bean.deploy.BeanComponentActivator;
import org.switchyard.component.bean.deploy.BeanDeploymentMetaData;
import org.switchyard.component.bean.deploy.ServiceDescriptor;
import org.switchyard.deploy.ServiceDomainManager;
import org.switchyard.deploy.internal.AbstractDeployment;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.metadata.ServiceInterface;
import org.switchyard.transform.TransformerRegistry;
import org.switchyard.transform.config.model.TransformerFactory;
import org.switchyard.transform.config.model.TransformerTypes;

public class SimpleCDIDeployment
extends AbstractDeployment {
    public SimpleCDIDeployment() {
        super(null);
    }

    public void init(ServiceDomain appServiceDomain) {
        super.init(ServiceDomainManager.createDomain());
    }

    public void start() {
        BeanDeploymentMetaData beanDeploymentMetaData = BeanDeploymentMetaData.lookupBeanDeploymentMetaData();
        this.deployTransformers(beanDeploymentMetaData, this.getDomain());
        this.deployServicesAndProxies(beanDeploymentMetaData, this.getDomain());
    }

    public void stop() {
    }

    public void destroy() {
    }

    private void deployTransformers(BeanDeploymentMetaData beanDeploymentMetaData, ServiceDomain domain) {
        TransformerRegistry transformerRegistry = domain.getTransformerRegistry();
        for (Class<?> deploymentClass : beanDeploymentMetaData.getDeploymentClasses()) {
            if (!TransformerFactory.isTransformer(deploymentClass)) continue;
            List transformers = TransformerFactory.listTransformations(deploymentClass);
            for (TransformerTypes transformer : transformers) {
                transformerRegistry.addTransformer(TransformerFactory.newTransformer(deploymentClass, (QName)transformer.getFrom(), (QName)transformer.getTo()));
            }
        }
    }

    private void deployServicesAndProxies(BeanDeploymentMetaData beanDeploymentMetaData, ServiceDomain domain) {
        if (beanDeploymentMetaData == null) {
            throw new SwitchYardException("Failed to lookup BeanDeploymentMetaData from Naming Context.");
        }
        BeanComponentActivator activator = new BeanComponentActivator();
        for (ServiceDescriptor serviceDescriptor : beanDeploymentMetaData.getServiceDescriptors()) {
            QName serviceName = serviceDescriptor.getServiceName();
            ExchangeHandler handler = serviceDescriptor.getHandler();
            activator.lookupBeanMetaData();
            ServiceInterface serviceInterface = activator.buildServiceInterface(serviceName);
            ServiceReference service = domain.registerService(serviceName, handler, serviceInterface);
            activator.start(service);
        }
    }
}

