/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.forge.http;

import javax.inject.Inject;
import org.jboss.forge.project.Project;
import org.jboss.forge.project.facets.MetadataFacet;
import org.jboss.forge.shell.ShellColor;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.Command;
import org.jboss.forge.shell.plugins.Help;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.PipeOut;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.RequiresFacet;
import org.jboss.forge.shell.plugins.RequiresProject;
import org.jboss.forge.shell.plugins.Topic;
import org.switchyard.component.common.selector.config.model.OperationSelectorModel;
import org.switchyard.component.common.selector.config.model.v1.V1StaticOperationSelectorModel;
import org.switchyard.component.http.config.model.HttpBindingModel;
import org.switchyard.config.model.composite.BindingModel;
import org.switchyard.config.model.composite.CompositeReferenceModel;
import org.switchyard.config.model.composite.CompositeServiceModel;
import org.switchyard.tools.forge.http.HttpFacet;
import org.switchyard.tools.forge.plugin.SwitchYardFacet;

@Alias(value="http-binding")
@RequiresProject
@RequiresFacet(value={SwitchYardFacet.class, HttpFacet.class})
@Topic(value="SOA")
@Help(value="Provides commands to manage HTTP service bindings in SwitchYard.")
public class HttpBindingPlugin
implements Plugin {
    @Inject
    private Project _project;

    @Command(value="bind-service", help="Add a HTTP binding to a service.")
    public void bindService(@Option(required=true, name="serviceName", description="The service name") String serviceName, @Option(required=true, name="operationName", description="The operation name") String operationName, @Option(required=true, name="contextPath", description="The context root for this HTTP endpoint, defaults to [projectName]") String contextPath, PipeOut out) {
        SwitchYardFacet switchYard = (SwitchYardFacet)this._project.getFacet(SwitchYardFacet.class);
        CompositeServiceModel service = switchYard.getCompositeService(serviceName);
        if (service == null) {
            out.println(out.renderColor(ShellColor.RED, "No public service named: " + serviceName));
            return;
        }
        HttpBindingModel binding = new HttpBindingModel();
        String projectName = ((MetadataFacet)this._project.getFacet(MetadataFacet.class)).getProjectName();
        if (contextPath != null && contextPath.length() > 0) {
            binding.setContextPath(contextPath);
        } else {
            binding.setContextPath(projectName);
        }
        if (operationName != null) {
            V1StaticOperationSelectorModel operation = new V1StaticOperationSelectorModel();
            operation.setOperationName(operationName);
            binding.setOperationSelector((OperationSelectorModel)operation);
        }
        service.addBinding((BindingModel)binding);
        switchYard.saveConfig();
        out.println("Added binding.http to service " + serviceName);
    }

    @Command(value="bind-reference", help="Add a SOAP binding to a reference.")
    public void bindReference(@Option(required=true, name="referenceName", description="The reference name") String referenceName, @Option(required=true, name="address", description="The remote HTTP endpoint's address") String address, @Option(required=false, name="method", description="The HTTP method used for invoking the endpoint. Can be GET, POST, etc.,") String method, @Option(required=false, name="contentType", description="The HTTP Content-Type header value that identifies the body content") String contentType, PipeOut out) {
        SwitchYardFacet switchYard = (SwitchYardFacet)this._project.getFacet(SwitchYardFacet.class);
        CompositeReferenceModel reference = switchYard.getCompositeReference(referenceName);
        if (reference == null) {
            out.println(out.renderColor(ShellColor.RED, "No public reference named: " + referenceName));
            return;
        }
        HttpBindingModel binding = new HttpBindingModel();
        if (address != null) {
            binding.setAddress(address);
        }
        if (method != null) {
            binding.setMethod(method);
        }
        if (contentType != null) {
            binding.setContentType(contentType);
        }
        reference.addBinding((BindingModel)binding);
        switchYard.saveConfig();
        out.println("Added binding.http to reference " + referenceName);
    }
}

