/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.forge.jca;

import javax.inject.Inject;
import org.jboss.forge.project.Project;
import org.jboss.forge.shell.PromptType;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.ShellColor;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.Command;
import org.jboss.forge.shell.plugins.Help;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.PipeOut;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.RequiresFacet;
import org.jboss.forge.shell.plugins.RequiresProject;
import org.jboss.forge.shell.plugins.Topic;
import org.switchyard.component.jca.config.model.v1.V1ActivationSpecModel;
import org.switchyard.component.jca.config.model.v1.V1ConnectionModel;
import org.switchyard.component.jca.config.model.v1.V1EndpointModel;
import org.switchyard.component.jca.config.model.v1.V1InboundConnectionModel;
import org.switchyard.component.jca.config.model.v1.V1InboundInteractionModel;
import org.switchyard.component.jca.config.model.v1.V1JCABindingModel;
import org.switchyard.component.jca.config.model.v1.V1ListenerModel;
import org.switchyard.component.jca.config.model.v1.V1OutboundConnectionModel;
import org.switchyard.component.jca.config.model.v1.V1OutboundInteractionModel;
import org.switchyard.component.jca.config.model.v1.V1ProcessorModel;
import org.switchyard.component.jca.config.model.v1.V1ResourceAdapterModel;
import org.switchyard.component.jca.endpoint.JMSEndpoint;
import org.switchyard.component.jca.processor.JMSProcessor;
import org.switchyard.config.model.composite.BindingModel;
import org.switchyard.config.model.composite.CompositeReferenceModel;
import org.switchyard.config.model.composite.CompositeServiceModel;
import org.switchyard.tools.forge.common.CommonFacet;
import org.switchyard.tools.forge.jca.JCAFacet;
import org.switchyard.tools.forge.plugin.SwitchYardFacet;

@Alias(value="jca-binding")
@RequiresProject
@RequiresFacet(value={SwitchYardFacet.class, CommonFacet.class, JCAFacet.class})
@Topic(value="SOA")
@Help(value="Provides commands to manage JCA service bindings in SwitchYard.")
public class JCABindingPlugin
implements Plugin {
    @Inject
    private Project _project;
    @Inject
    private Shell _shell;

    @Command(value="bind-service", help="Add a JCA binding to a service.")
    public void bindService(@Option(required=true, name="serviceName", description="The service name") String serviceName, @Option(required=false, name="resourceAdapter", defaultValue="hornetq-ra.rar", description="Name of the ResourceAdapter archive") String resourceAdapter, @Option(required=false, name="listener", defaultValue="javax.jms.Listener", description="Fully qualified name of the listener interface") String listener, @Option(required=false, name="endpoint", defaultValue="org.switchyard.component.jca.endpoint.JMSEndpoint", description="Fully qualified name of the endpoint class") String endpoint, @Option(required=false, name="transacted", defaultValue="true", description="Whether the binding should be transacted or not") Boolean transacted, PipeOut out) {
        SwitchYardFacet switchYard = (SwitchYardFacet)this._project.getFacet(SwitchYardFacet.class);
        CompositeServiceModel service = switchYard.getCompositeService(serviceName);
        if (service == null) {
            out.println(out.renderColor(ShellColor.RED, "No public service named: " + serviceName));
            return;
        }
        V1JCABindingModel binding = new V1JCABindingModel();
        V1InboundConnectionModel connectionModel = new V1InboundConnectionModel();
        V1ResourceAdapterModel rar = new V1ResourceAdapterModel();
        rar.setName(resourceAdapter);
        connectionModel.setResourceAdapter(rar);
        if (endpoint.equals(JMSEndpoint.class.getName())) {
            V1ActivationSpecModel activationSpec = new V1ActivationSpecModel();
            String destinationType = this._shell.promptCommon("destinationType", PromptType.ANY, "javax.jms.Queue");
            String destination = this._shell.promptCommon("destination name", PromptType.ANY, "InboundQueue");
            activationSpec.setProperty("destinationType", destinationType);
            activationSpec.setProperty("destination", destination);
            connectionModel.setActivationSpec(activationSpec);
        }
        binding.setInboundConnection(connectionModel);
        V1InboundInteractionModel interactionModel = new V1InboundInteractionModel();
        V1ListenerModel listenerModel = new V1ListenerModel();
        listenerModel.setClassName(listener);
        interactionModel.setListener(listenerModel);
        V1EndpointModel endpointModel = new V1EndpointModel();
        endpointModel.setEndpointClassName(endpoint);
        interactionModel.setEndpoint(endpointModel);
        interactionModel.setTransacted(transacted);
        binding.setInboundInteraction(interactionModel);
        service.addBinding((BindingModel)binding);
        switchYard.saveConfig();
        out.println("Added binding.jca to service " + serviceName);
    }

    @Command(value="bind-reference", help="Add a SOAP binding to a reference.")
    public void bindReference(@Option(required=true, name="referenceName", description="The reference name") String referenceName, @Option(required=false, name="resourceAdapter", defaultValue="hornetq-ra.rar", description="Name of the ResourceAdapter archive") String resourceAdapter, @Option(required=false, name="connectionFactory", defaultValue="java:/JmsXA", description="JNDI name of the ConnectionFactory") String connectionFactory, @Option(required=false, name="processor", defaultValue="org.switchyard.component.jca.processor.JMSProcessor", description="Fully qualified name of the outbound processor class") String processor, PipeOut out) {
        SwitchYardFacet switchYard = (SwitchYardFacet)this._project.getFacet(SwitchYardFacet.class);
        CompositeReferenceModel reference = switchYard.getCompositeReference(referenceName);
        if (reference == null) {
            out.println(out.renderColor(ShellColor.RED, "No public reference named: " + referenceName));
            return;
        }
        V1JCABindingModel binding = new V1JCABindingModel();
        V1OutboundConnectionModel connectionModel = new V1OutboundConnectionModel();
        V1ResourceAdapterModel rarModel = new V1ResourceAdapterModel();
        rarModel.setName(resourceAdapter);
        connectionModel.setResourceAdapter(rarModel);
        V1ConnectionModel connection = new V1ConnectionModel();
        connection.setConnectionFactoryJNDIName(connectionFactory);
        connectionModel.setConnection(connection);
        binding.setOutboundConnection(connectionModel);
        V1OutboundInteractionModel interactionModel = new V1OutboundInteractionModel();
        V1ProcessorModel processorModel = new V1ProcessorModel();
        processorModel.setProcessorClassName(processor);
        if (processor.equals(JMSProcessor.class.getName())) {
            String destination = this._shell.promptCommon("destination name", PromptType.ANY, "OutboundQueue");
            processorModel.setProperty("destination", destination);
        }
        interactionModel.setProcessor(processorModel);
        binding.setOutboundInteraction(interactionModel);
        reference.addBinding((BindingModel)binding);
        switchYard.saveConfig();
        out.println("Added binding.jca to reference " + referenceName);
    }
}

