/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.rules.util.drools;

import java.util.Properties;
import org.drools.KnowledgeBaseConfiguration;
import org.drools.KnowledgeBaseFactory;
import org.drools.agent.KnowledgeAgentConfiguration;
import org.drools.agent.KnowledgeAgentFactory;
import org.drools.builder.KnowledgeBuilderConfiguration;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.conf.EventProcessingOption;
import org.drools.conf.KnowledgeBaseOption;
import org.drools.conf.MaxThreadsOption;
import org.drools.conf.MultithreadEvaluationOption;
import org.drools.impl.EnvironmentFactory;
import org.drools.runtime.Environment;
import org.drools.runtime.KnowledgeSessionConfiguration;
import org.drools.runtime.conf.ClockTypeOption;
import org.drools.runtime.conf.KnowledgeSessionOption;
import org.switchyard.common.type.Classes;
import org.switchyard.component.common.rules.ClockType;
import org.switchyard.component.common.rules.EventProcessingType;
import org.switchyard.component.common.rules.config.model.ComponentImplementationModel;

public final class Configs {
    public static KnowledgeBaseConfiguration getBaseConfiguration(ComponentImplementationModel model, ClassLoader loader) {
        EventProcessingType eventProcessing;
        KnowledgeBaseConfiguration kbaseConfig = KnowledgeBaseFactory.newKnowledgeBaseConfiguration((Properties)Configs.getProperties(), (ClassLoader[])new ClassLoader[]{Configs.getLoader(loader)});
        Boolean multithreadEvaluation = model.getMultithreadEvaluation();
        if (multithreadEvaluation != null) {
            Integer maxThreads;
            boolean me = multithreadEvaluation;
            MultithreadEvaluationOption meo = me ? MultithreadEvaluationOption.YES : MultithreadEvaluationOption.NO;
            kbaseConfig.setOption((KnowledgeBaseOption)meo);
            if (me && (maxThreads = model.getMaxThreads()) != null) {
                kbaseConfig.setOption((KnowledgeBaseOption)MaxThreadsOption.get((int)maxThreads));
            }
        }
        if ((eventProcessing = model.getEventProcessing()) != null) {
            switch (eventProcessing) {
                case STREAM: {
                    kbaseConfig.setOption((KnowledgeBaseOption)EventProcessingOption.STREAM);
                    break;
                }
                case CLOUD: {
                    kbaseConfig.setOption((KnowledgeBaseOption)EventProcessingOption.CLOUD);
                }
            }
        }
        return kbaseConfig;
    }

    public static KnowledgeAgentConfiguration getAgentConfiguration() {
        return KnowledgeAgentFactory.newKnowledgeAgentConfiguration((Properties)Configs.getProperties());
    }

    public static KnowledgeBuilderConfiguration getBuilderConfiguration(ClassLoader loader) {
        return KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration((Properties)Configs.getProperties(), (ClassLoader[])new ClassLoader[]{Configs.getLoader(loader)});
    }

    public static KnowledgeSessionConfiguration getSessionConfiguration(ComponentImplementationModel model) {
        KnowledgeSessionConfiguration ksessionConfig = KnowledgeBaseFactory.newKnowledgeSessionConfiguration((Properties)Configs.getProperties());
        ClockType clock = model.getClock();
        if (clock != null) {
            switch (clock) {
                case REALTIME: {
                    ksessionConfig.setOption((KnowledgeSessionOption)ClockTypeOption.get((String)org.drools.ClockType.REALTIME_CLOCK.getId()));
                    break;
                }
                case PSEUDO: {
                    ksessionConfig.setOption((KnowledgeSessionOption)ClockTypeOption.get((String)org.drools.ClockType.PSEUDO_CLOCK.getId()));
                }
            }
        }
        return ksessionConfig;
    }

    public static Environment getEnvironment() {
        return EnvironmentFactory.newEnvironment();
    }

    private static Properties getProperties() {
        Properties properties = new Properties();
        properties.setProperty("drools.classLoaderCacheEnabled", Boolean.FALSE.toString());
        return properties;
    }

    private static ClassLoader getLoader(ClassLoader loader) {
        if (loader == null) {
            loader = Classes.getClassLoader(Configs.class);
        }
        return loader;
    }

    private Configs() {
    }
}

