/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.maven.plugins.switchyard;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.switchyard.common.type.Classes;
import org.switchyard.config.OutputKey;
import org.switchyard.config.model.MergeScanner;
import org.switchyard.config.model.Model;
import org.switchyard.config.model.ModelPullerScanner;
import org.switchyard.config.model.Scanner;
import org.switchyard.config.model.ScannerInput;
import org.switchyard.config.model.switchyard.v1.V1SwitchYardModel;

public class ConfigureMojo<M extends Model>
extends AbstractMojo {
    private static final String SWITCHARD_XML_FILE_NAME = "switchyard.xml";
    private static final String SWITCHYARD_XML_DEFAULT_FOLDER = "META-INF";
    private static final String DEFAULT_SWITCHYARD_XML_FILE_PATH = "META-INF" + File.separator + "switchyard.xml";
    private String modelClassName;
    private String[] scannerClassNames = new String[0];
    private File[] scanDirectories = new File[0];
    private List<String> compileClasspathElements;
    private List<Resource> resources;
    private String artifactId;
    private File outputDirectory;
    private File outputFile;
    private boolean validate = true;

    public void execute() throws MojoExecutionException, MojoFailureException {
        final ArrayList<URL> mojoURLs = new ArrayList<URL>();
        try {
            for (String compileClasspaths : this.compileClasspathElements) {
                mojoURLs.add(new File(compileClasspaths).toURI().toURL());
            }
            for (Resource resource : this.resources) {
                File file;
                String path = resource.getTargetPath();
                if (path == null || !(file = new File(path)).exists()) continue;
                mojoURLs.add(file.toURI().toURL());
            }
            if (this.outputDirectory.getAbsoluteFile().exists()) {
                mojoURLs.add(this.outputDirectory.getAbsoluteFile().toURI().toURL());
            }
            for (File scanDir : this.scanDirectories) {
                if (scanDir == null || !(scanDir = scanDir.getAbsoluteFile()).exists()) continue;
                mojoURLs.add(scanDir.toURI().toURL());
            }
        }
        catch (MalformedURLException mue) {
            throw new MojoExecutionException(mue.getMessage(), (Exception)mue);
        }
        ClassLoader loader = AccessController.doPrivileged(new PrivilegedAction<URLClassLoader>(){

            @Override
            public URLClassLoader run() {
                return new URLClassLoader(mojoURLs.toArray(new URL[mojoURLs.size()]), ConfigureMojo.class.getClassLoader());
            }
        });
        ClassLoader previous = Classes.setTCCL((ClassLoader)loader);
        Writer writer = null;
        try {
            ArrayList<Scanner<M>> scanners = new ArrayList<Scanner<M>>();
            for (String scannerClassName : this.scannerClassNames) {
                Class scannerClass = Classes.forName((String)scannerClassName, (ClassLoader)loader);
                if (scannerClass == null) continue;
                Scanner scanner = (Scanner)scannerClass.newInstance();
                scanners.add(scanner);
            }
            this.addModelPullerScanners(scanners);
            if (this.modelClassName == null) {
                this.modelClassName = V1SwitchYardModel.class.getName();
            }
            Class modelClass = Classes.forName((String)this.modelClassName, (ClassLoader)loader);
            MergeScanner merge_scanner = new MergeScanner(modelClass, true, scanners);
            ArrayList<URL> scannerURLs = new ArrayList<URL>();
            if (this.scanDirectories.length == 0) {
                scannerURLs.add(this.outputDirectory.toURI().toURL());
            } else {
                for (File scanDir : this.scanDirectories) {
                    if (scanDir == null) continue;
                    scannerURLs.add(scanDir.toURI().toURL());
                }
            }
            this.getLog().info((CharSequence)("SwitchYard plugin scanning: " + scannerURLs));
            ScannerInput scanner_input = new ScannerInput().setName(this.artifactId).setURLs(scannerURLs);
            Model model = merge_scanner.scan(scanner_input).getModel();
            if (this.outputFile == null) {
                File od = new File(this.outputDirectory, SWITCHYARD_XML_DEFAULT_FOLDER);
                if (!od.exists() && !od.mkdirs()) {
                    throw new Exception("mkdirs() on " + od + " failed.");
                }
                this.outputFile = new File(od, SWITCHARD_XML_FILE_NAME);
            }
            this.getLog().info((CharSequence)("Outputting SwitchYard configuration model to " + this.outputFile.getAbsolutePath()));
            writer = new BufferedWriter(new FileWriter(this.outputFile));
            model.write(writer, new OutputKey[0]);
            writer.flush();
            if (this.validate) {
                this.getLog().info((CharSequence)"Validating SwitchYard configuration model...");
                model.assertModelValid();
            } else {
                this.getLog().warn((CharSequence)"Skipping validation of SwitchYard configuration model. (Enable with <validate>true</validate>.)");
            }
        }
        catch (Throwable t) {
            throw new MojoExecutionException(t.getMessage(), t);
        }
        finally {
            Classes.setTCCL((ClassLoader)previous);
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException ioe) {
                    throw new MojoExecutionException(ioe.getMessage(), (Exception)ioe);
                }
            }
        }
    }

    private void addModelPullerScanners(List<Scanner<M>> scanners) throws IOException {
        for (Resource resource : this.resources) {
            this.addModelPullerScanner(new File(resource.getDirectory()).getCanonicalFile(), this.convertInExcludes(resource.getIncludes()), this.convertInExcludes(resource.getExcludes()), scanners);
        }
        for (File file : this.scanDirectories) {
            this.addModelPullerScanner(file.getCanonicalFile(), null, null, scanners);
        }
    }

    private void addModelPullerScanner(File baseDir, String includes, String excludes, List<Scanner<M>> scanners) throws IOException {
        File switchYardFile = new File(baseDir, DEFAULT_SWITCHYARD_XML_FILE_PATH).getCanonicalFile();
        for (File file : FileUtils.getFiles((File)baseDir, (String)includes, (String)excludes)) {
            if (!switchYardFile.equals(file = file.getCanonicalFile())) continue;
            scanners.add((Scanner<M>)new ModelPullerScanner(file));
            return;
        }
    }

    private String convertInExcludes(List<String> cludes) {
        if (cludes == null) {
            return null;
        }
        String converted = StringUtils.join(cludes.iterator(), (String)",");
        if (converted.length() == 0) {
            return null;
        }
        return converted;
    }
}

