/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.remote;

import javax.xml.namespace.QName;
import org.switchyard.Service;
import org.switchyard.metadata.ServiceInterface;
import org.switchyard.remote.RemoteInterface;
import org.switchyard.serial.graph.AccessType;
import org.switchyard.serial.graph.Strategy;

@Strategy(access=AccessType.FIELD)
public class RemoteEndpoint {
    private QName _serviceName;
    private QName _domainName;
    private String _endpoint;
    private String _node;
    private ServiceInterface _contract;

    public RemoteEndpoint() {
    }

    public RemoteEndpoint(QName serviceName, QName domainName, String endpoint, String node, ServiceInterface contract) {
        this._serviceName = serviceName;
        this._domainName = domainName;
        this._endpoint = endpoint;
        this._node = node;
        this._contract = contract;
    }

    public QName getServiceName() {
        return this._serviceName;
    }

    public RemoteEndpoint setServiceName(QName serviceName) {
        this._serviceName = serviceName;
        return this;
    }

    public QName getDomainName() {
        return this._domainName;
    }

    public RemoteEndpoint setDomainName(QName domainName) {
        this._domainName = domainName;
        return this;
    }

    public String getEndpoint() {
        return this._endpoint;
    }

    public RemoteEndpoint setEndpoint(String endpoint) {
        this._endpoint = endpoint;
        return this;
    }

    public ServiceInterface getContract() {
        return this._contract;
    }

    public RemoteEndpoint setContract(ServiceInterface contract) {
        this._contract = contract;
        return this;
    }

    public String getNode() {
        return this._node;
    }

    public RemoteEndpoint setNode(String node) {
        this._node = node;
        return this;
    }

    public static RemoteEndpoint fromService(Service service) {
        return new RemoteEndpoint(service.getName(), service.getDomain().getName(), null, null, (ServiceInterface)RemoteInterface.fromInterface(service.getInterface()));
    }
}

