/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.rhq.plugin;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.switchyard.rhq.plugin.ComponentServiceResourceComponent;
import org.switchyard.rhq.plugin.model.ComponentReference;

public class ComponentReferenceDiscoveryComponent
implements ResourceDiscoveryComponent<ComponentServiceResourceComponent> {
    private static Log LOG = LogFactory.getLog(ComponentReferenceDiscoveryComponent.class);

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<ComponentServiceResourceComponent> context) {
        HashSet<DiscoveredResourceDetails> discoveredResources = new HashSet<DiscoveredResourceDetails>();
        ComponentServiceResourceComponent parent = (ComponentServiceResourceComponent)context.getParentResourceComponent();
        Map<String, ComponentReference> references = parent.getReferences();
        if (references != null) {
            for (ComponentReference reference : references.values()) {
                Configuration pluginConfig = context.getDefaultPluginConfiguration();
                QName name = reference.getName();
                DiscoveredResourceDetails resource = new DiscoveredResourceDetails(context.getResourceType(), name.toString(), name.getLocalPart(), name.getNamespaceURI(), null, pluginConfig, null);
                discoveredResources.add(resource);
                LOG.debug((Object)("Discovered SwitchYard Component Reference " + reference));
            }
        }
        return discoveredResources;
    }
}

