/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.rhq.plugin;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.switchyard.rhq.plugin.ComponentServiceResourceComponent;
import org.switchyard.rhq.plugin.model.ComponentService;
import org.switchyard.rhq.plugin.model.OperationMetrics;

public class ComponentServiceOperationDiscoveryComponent
implements ResourceDiscoveryComponent<ComponentServiceResourceComponent> {
    private static Log LOG = LogFactory.getLog(ComponentServiceOperationDiscoveryComponent.class);

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<ComponentServiceResourceComponent> context) {
        HashSet<DiscoveredResourceDetails> discoveredResources = new HashSet<DiscoveredResourceDetails>();
        ComponentServiceResourceComponent parent = (ComponentServiceResourceComponent)context.getParentResourceComponent();
        ComponentService service = parent.getComponentService();
        if (service != null) {
            Map<String, OperationMetrics> metrics = parent.getOperationMetrics();
            QName serviceName = service.getName();
            for (String operationName : metrics.keySet()) {
                Configuration pluginConfig = context.getDefaultPluginConfiguration();
                DiscoveredResourceDetails resource = new DiscoveredResourceDetails(context.getResourceType(), operationName, operationName, serviceName.getNamespaceURI(), null, pluginConfig, null);
                discoveredResources.add(resource);
                LOG.debug((Object)("Discovered SwitchYard Component Service Operation " + operationName));
            }
        }
        return discoveredResources;
    }
}

