/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.rhq.plugin;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.switchyard.rhq.plugin.ReferenceResourceComponent;
import org.switchyard.rhq.plugin.model.OperationMetrics;
import org.switchyard.rhq.plugin.model.Reference;

public class ReferenceOperationDiscoveryComponent
implements ResourceDiscoveryComponent<ReferenceResourceComponent> {
    private static Log LOG = LogFactory.getLog(ReferenceOperationDiscoveryComponent.class);

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<ReferenceResourceComponent> context) {
        HashSet<DiscoveredResourceDetails> discoveredResources = new HashSet<DiscoveredResourceDetails>();
        ReferenceResourceComponent parent = (ReferenceResourceComponent)context.getParentResourceComponent();
        Reference reference = parent.getReference();
        if (reference != null) {
            Map<String, OperationMetrics> metrics = parent.getOperationMetrics();
            QName referenceName = reference.getName();
            for (String operationName : metrics.keySet()) {
                Configuration pluginConfig = context.getDefaultPluginConfiguration();
                DiscoveredResourceDetails resource = new DiscoveredResourceDetails(context.getResourceType(), operationName, operationName, referenceName.getNamespaceURI(), null, pluginConfig, null);
                discoveredResources.add(resource);
                LOG.debug((Object)("Discovered SwitchYard Reference Operation " + operationName));
            }
        }
        return discoveredResources;
    }
}

