/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.rhq.plugin;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.modules.plugins.jbossas7.BaseComponent;
import org.rhq.modules.plugins.jbossas7.ManagedASComponent;
import org.rhq.modules.plugins.jbossas7.json.Address;
import org.rhq.modules.plugins.jbossas7.json.Operation;
import org.switchyard.rhq.plugin.ApplicationResourceComponent;
import org.switchyard.rhq.plugin.BaseSwitchYardResourceComponent;
import org.switchyard.rhq.plugin.SwitchYardConstants;
import org.switchyard.rhq.plugin.SwitchYardResourceComponent;
import org.switchyard.rhq.plugin.model.Application;
import org.switchyard.rhq.plugin.model.Gateway;
import org.switchyard.rhq.plugin.model.GatewayMetrics;
import org.switchyard.rhq.plugin.model.OperationMetrics;
import org.switchyard.rhq.plugin.model.Service;
import org.switchyard.rhq.plugin.model.ServiceMetrics;
import org.switchyard.rhq.plugin.model.Throttling;
import org.switchyard.rhq.plugin.operations.ResetServiceMetrics;
import org.switchyard.rhq.plugin.operations.UpdateThrottling;

public class ServiceResourceComponent
extends BaseSwitchYardResourceComponent<ApplicationResourceComponent>
implements MeasurementFacet,
OperationFacet {
    private static Log LOG = LogFactory.getLog(ServiceResourceComponent.class);

    @Override
    protected Log getLog() {
        return LOG;
    }

    public AvailabilityType getAvailability() {
        Service service = this.getService();
        return service == null ? AvailabilityType.DOWN : AvailabilityType.UP;
    }

    public Map<String, Gateway> getGateways() {
        Service service = this.getService();
        if (service == null) {
            return Collections.emptyMap();
        }
        return service.getGateways();
    }

    public Service getService() {
        String serviceKey = this.getResourceContext().getResourceKey();
        return this.getApplication().getServices().get(serviceKey);
    }

    public Application getApplication() {
        return ((ApplicationResourceComponent)this.getResourceContext().getParentResourceComponent()).getApplication();
    }

    public void clearServiceMetrics() {
        ((ApplicationResourceComponent)this.getResourceContext().getParentResourceComponent()).clearServiceMetrics();
    }

    private ServiceMetrics getServiceMetrics() {
        String serviceKey = this.getResourceContext().getResourceKey();
        Map<String, ServiceMetrics> serviceMetrics = ((ApplicationResourceComponent)this.getResourceContext().getParentResourceComponent()).getServiceMetrics();
        return serviceMetrics != null ? serviceMetrics.get(serviceKey) : null;
    }

    public Map<String, OperationMetrics> getOperationMetrics() {
        ServiceMetrics serviceMetrics = this.getServiceMetrics();
        if (serviceMetrics != null) {
            return serviceMetrics.getOperationMetrics();
        }
        return Collections.emptyMap();
    }

    public Map<String, GatewayMetrics> getGatewayMetrics() {
        ServiceMetrics serviceMetrics = this.getServiceMetrics();
        if (serviceMetrics != null) {
            return serviceMetrics.getGatewayMetrics();
        }
        return Collections.emptyMap();
    }

    public void clearApplications() {
        ((ApplicationResourceComponent)this.getResourceContext().getParentResourceComponent()).clearApplications();
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> requests) throws Exception {
        ServiceMetrics metrics = this.getServiceMetrics();
        Service service = this.getService();
        if (metrics != null && service != null) {
            for (MeasurementScheduleRequest request : requests) {
                MeasurementDataNumeric measurementData = this.getCommonMetric(request, metrics);
                if (measurementData != null) {
                    report.addData(measurementData);
                    continue;
                }
                String name = request.getName();
                Throttling throttling = service.getThrottling();
                if ("throttlingEnabled".equals(name)) {
                    report.addData(new MeasurementDataTrait(request, Boolean.toString(throttling.isEnabled())));
                    continue;
                }
                if ("TimePeriod".equals(name)) {
                    report.addData(new MeasurementDataTrait(request, Long.toString(throttling.getTimePeriod())));
                    continue;
                }
                if ("MaxRequests".equals(name)) {
                    report.addData(new MeasurementDataTrait(request, Integer.toString(throttling.getMaxRequests())));
                    continue;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Unable to collect Service measurement " + request.getName()));
            }
        }
    }

    private Address getAddress() {
        SwitchYardResourceComponent src;
        BaseComponent component = null;
        ApplicationResourceComponent arc = (ApplicationResourceComponent)this.getResourceContext().getParentResourceComponent();
        if (arc != null && arc.getResourceContext() != null && arc.getResourceContext().getParentResourceComponent() != null && (src = (SwitchYardResourceComponent)arc.getResourceContext().getParentResourceComponent()) != null && src.getResourceContext() != null && src.getResourceContext().getParentResourceComponent() != null) {
            component = (BaseComponent)src.getResourceContext().getParentResourceComponent();
        }
        String parentPath = null;
        if (component != null) {
            component.getPath();
        }
        if (parentPath == null || parentPath.isEmpty()) {
            parentPath = "";
        }
        String path = parentPath;
        if (component instanceof ManagedASComponent) {
            if (path.startsWith("host=")) {
                path = path.replaceAll(",server-config=", ",server=");
                parentPath = parentPath.replaceAll(",server-config=", ",server=");
                Address addr = new Address(parentPath + "," + "subsystem=switchyard");
                return addr;
            }
            return null;
        }
        return null;
    }

    private Operation getResetServiceMetrics(String applicationName, String serviceName) {
        ResetServiceMetrics operation = new ResetServiceMetrics(applicationName, serviceName);
        Address addr = this.getAddress();
        if (addr != null) {
            operation = new Operation("reset-metrics", addr);
            operation.addAdditionalProperty("application-name", applicationName);
            operation.addAdditionalProperty("name", serviceName);
            operation.addAdditionalProperty("type", "service");
        }
        return operation;
    }

    private Operation getUpdateThrottling(String applicationName, String compositeName, Boolean enabled, Integer maxRequests) {
        UpdateThrottling operation = new UpdateThrottling(applicationName, compositeName, enabled, maxRequests);
        Address addr = this.getAddress();
        if (addr != null) {
            operation = new Operation("update-throttling", addr);
        }
        operation.addAdditionalProperty("application-name", applicationName);
        operation.addAdditionalProperty("service-name", compositeName);
        operation.addAdditionalProperty("throttling", new Throttling(enabled, maxRequests, null));
        return operation;
    }

    public OperationResult invokeOperation(String name, Configuration parameters) throws InterruptedException, Exception {
        if ("reset".equals(name)) {
            Service service = this.getService();
            Application application = this.getApplication();
            if (service != null && application != null) {
                String serviceName = service.getName().toString();
                String applicationName = application.getName().toString();
                this.execute(this.getResetServiceMetrics(applicationName, serviceName), Void.class);
                this.clearServiceMetrics();
            }
        } else if (SwitchYardConstants.OPERATION_SET_THROTTLING.equals(name)) {
            PropertySimple enabled = (PropertySimple)parameters.get("enabled");
            PropertySimple maxRequests = (PropertySimple)parameters.get("maxRequests");
            Service service = this.getService();
            Application application = this.getApplication();
            if (service != null && application != null) {
                String serviceName = service.getName().toString();
                String applicationName = application.getName().toString();
                this.execute(this.getUpdateThrottling(applicationName, serviceName, enabled != null ? enabled.getBooleanValue() : null, maxRequests != null ? maxRequests.getIntegerValue() : null), Void.class);
                this.clearApplications();
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.warn((Object)("Unknown Service operation " + name));
        }
        return null;
    }

    public <T> T execute(Operation operation, Class<T> clazz) {
        return ((ApplicationResourceComponent)this.getResourceContext().getParentResourceComponent()).execute(operation, clazz);
    }
}

