/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.handlers;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.logging.Logger;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.HandlerException;
import org.switchyard.Property;
import org.switchyard.Scope;
import org.switchyard.label.BehaviorLabel;
import org.switchyard.policy.Policy;
import org.switchyard.policy.PolicyUtil;
import org.switchyard.policy.TransactionPolicy;
import org.switchyard.runtime.RuntimeLogger;
import org.switchyard.runtime.RuntimeMessages;

public class TransactionHandler
implements ExchangeHandler {
    private static final String JNDI_TRANSACTION_MANAGER = "java:jboss/TransactionManager";
    private static final String SUSPENDED_TRANSACTION_PROPERTY = "org.switchyard.exchange.transaction.suspended";
    private static final String INITIATED_TRANSACTION_PROPERTY = "org.switchyard.exchange.transaction.initiated";
    private static final String BEFORE_INVOKED_PROPERTY = "org.switchyard.exchange.transaction.beforeInvoked";
    private static Logger _log = Logger.getLogger(TransactionHandler.class);
    private TransactionManager _transactionManager;

    public TransactionHandler() {
        try {
            this._transactionManager = (TransactionManager)new InitialContext().lookup(JNDI_TRANSACTION_MANAGER);
        }
        catch (NamingException nmEx) {
            _log.debug((Object)"Unable to find TransactionManager in JNDI at java:jboss/TransactionManager - Transaction Policy handling will not be available.");
        }
    }

    public void handleMessage(Exchange exchange) throws HandlerException {
        if (this._transactionManager == null) {
            return;
        }
        Property prop = exchange.getContext().getProperty(BEFORE_INVOKED_PROPERTY, Scope.EXCHANGE);
        if (prop != null && ((Boolean)Boolean.class.cast(prop.getValue())).booleanValue()) {
            this.handleAfter(exchange);
        } else {
            exchange.getContext().setProperty(BEFORE_INVOKED_PROPERTY, (Object)Boolean.TRUE, Scope.EXCHANGE).addLabels(new String[]{BehaviorLabel.TRANSIENT.label()});
            this.handleBefore(exchange);
        }
    }

    public void handleFault(Exchange exchange) {
        if (this._transactionManager == null) {
            return;
        }
        try {
            Transaction transaction;
            Property rollbackOnFaultProperty = exchange.getContext().getProperty("org.switchyard.rollbackOnFault");
            if (rollbackOnFaultProperty != null && rollbackOnFaultProperty.getValue() != null && ((Boolean)Boolean.class.cast(rollbackOnFaultProperty.getValue())).booleanValue() && (transaction = this.getCurrentTransaction()) != null) {
                transaction.setRollbackOnly();
            }
            this.handleAfter(exchange);
        }
        catch (Exception e) {
            _log.error((Object)e);
        }
    }

    void setTransactionManager(TransactionManager transactionManager) {
        this._transactionManager = transactionManager;
    }

    TransactionManager getTransactionManager() {
        return this._transactionManager;
    }

    private void handleAfter(Exchange exchange) throws HandlerException {
        Transaction transaction = null;
        try {
            transaction = (Transaction)exchange.getContext().getPropertyValue(INITIATED_TRANSACTION_PROPERTY);
            if (transaction != null) {
                this.endTransaction();
            }
        }
        catch (Exception e) {
            throw RuntimeMessages.MESSAGES.failedToCompleteTransaction(e);
        }
        finally {
            transaction = (Transaction)exchange.getContext().getPropertyValue(SUSPENDED_TRANSACTION_PROPERTY);
            if (transaction != null) {
                this.resumeTransaction(transaction);
            }
        }
    }

    private void handleBefore(Exchange exchange) throws HandlerException {
        if (!(this.propagatesRequired(exchange) || this.suspendsRequired(exchange) || this.managedGlobalRequired(exchange) || this.managedLocalRequired(exchange) || this.noManagedRequired(exchange))) {
            return;
        }
        this.evaluatePolicyCombination(exchange);
        this.evaluateTransactionStatus(exchange);
        if (this.isEligibleToSuspendTransaction(exchange)) {
            this.suspendTransaction(exchange);
        }
        if (this.isEligibleToStartTransaction(exchange)) {
            this.startTransaction(exchange);
        }
        this.provideRequiredPolicies(exchange);
    }

    private void evaluatePolicyCombination(Exchange exchange) throws HandlerException {
        if (this.suspendsRequired(exchange) && this.propagatesRequired(exchange)) {
            throw RuntimeMessages.MESSAGES.invalidTransactionPolicy(TransactionPolicy.SUSPENDS_TRANSACTION.toString(), TransactionPolicy.PROPAGATES_TRANSACTION.toString());
        }
        if (this.managedGlobalRequired(exchange) && this.managedLocalRequired(exchange) || this.managedGlobalRequired(exchange) && this.noManagedRequired(exchange) || this.managedLocalRequired(exchange) && this.noManagedRequired(exchange)) {
            throw RuntimeMessages.MESSAGES.invalidTransactionPolicy(TransactionPolicy.MANAGED_TRANSACTION_GLOBAL.toString(), TransactionPolicy.NO_MANAGED_TRANSACTION.toString());
        }
        if (this.propagatesRequired(exchange) && this.managedLocalRequired(exchange) || this.propagatesRequired(exchange) && this.noManagedRequired(exchange)) {
            throw RuntimeMessages.MESSAGES.invalidTransactionPolicyCombo(TransactionPolicy.PROPAGATES_TRANSACTION.toString(), TransactionPolicy.MANAGED_TRANSACTION_LOCAL.toString(), TransactionPolicy.NO_MANAGED_TRANSACTION.toString());
        }
    }

    private void evaluateTransactionStatus(Exchange exchange) throws HandlerException {
        Transaction transaction = this.getCurrentTransaction();
        if (transaction == null && this.propagatesRequired(exchange) && !this.managedGlobalRequired(exchange)) {
            throw RuntimeMessages.MESSAGES.invalidTransactionStatus(TransactionPolicy.PROPAGATES_TRANSACTION.toString());
        }
    }

    private boolean isEligibleToSuspendTransaction(Exchange exchange) throws HandlerException {
        Transaction transaction = this.getCurrentTransaction();
        if (transaction == null) {
            return false;
        }
        return this.managedLocalRequired(exchange) || this.noManagedRequired(exchange) || this.suspendsRequired(exchange);
    }

    private boolean isEligibleToStartTransaction(Exchange exchange) throws HandlerException {
        Transaction transaction = this.getCurrentTransaction();
        if (this.managedLocalRequired(exchange)) {
            return true;
        }
        return this.managedGlobalRequired(exchange) && transaction == null;
    }

    private void provideRequiredPolicies(Exchange exchange) {
        if (this.suspendsRequired(exchange)) {
            this.provideSuspends(exchange);
        } else if (this.propagatesRequired(exchange)) {
            this.providePropagates(exchange);
        }
        if (this.managedGlobalRequired(exchange)) {
            this.provideManagedGlobal(exchange);
        } else if (this.managedLocalRequired(exchange)) {
            this.provideManagedLocal(exchange);
        } else if (this.noManagedRequired(exchange)) {
            this.provideNoManaged(exchange);
        }
    }

    private boolean managedGlobalRequired(Exchange exchange) {
        return PolicyUtil.isRequired((Exchange)exchange, (Policy)TransactionPolicy.MANAGED_TRANSACTION_GLOBAL);
    }

    private boolean managedLocalRequired(Exchange exchange) {
        return PolicyUtil.isRequired((Exchange)exchange, (Policy)TransactionPolicy.MANAGED_TRANSACTION_LOCAL);
    }

    private boolean noManagedRequired(Exchange exchange) {
        return PolicyUtil.isRequired((Exchange)exchange, (Policy)TransactionPolicy.NO_MANAGED_TRANSACTION);
    }

    private boolean suspendsRequired(Exchange exchange) {
        return PolicyUtil.isRequired((Exchange)exchange, (Policy)TransactionPolicy.SUSPENDS_TRANSACTION);
    }

    private boolean propagatesRequired(Exchange exchange) {
        return PolicyUtil.isRequired((Exchange)exchange, (Policy)TransactionPolicy.PROPAGATES_TRANSACTION);
    }

    private void providePropagates(Exchange exchange) {
        PolicyUtil.provide((Exchange)exchange, (Policy)TransactionPolicy.PROPAGATES_TRANSACTION);
    }

    private void provideSuspends(Exchange exchange) {
        PolicyUtil.provide((Exchange)exchange, (Policy)TransactionPolicy.SUSPENDS_TRANSACTION);
    }

    private void provideManagedGlobal(Exchange exchange) {
        PolicyUtil.provide((Exchange)exchange, (Policy)TransactionPolicy.MANAGED_TRANSACTION_GLOBAL);
    }

    private void provideManagedLocal(Exchange exchange) {
        PolicyUtil.provide((Exchange)exchange, (Policy)TransactionPolicy.MANAGED_TRANSACTION_LOCAL);
    }

    private void provideNoManaged(Exchange exchange) {
        PolicyUtil.provide((Exchange)exchange, (Policy)TransactionPolicy.NO_MANAGED_TRANSACTION);
    }

    private void startTransaction(Exchange exchange) throws HandlerException {
        Transaction transaction;
        int txStatus;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"creating new transaction");
        }
        if ((txStatus = this.getCurrentTransactionStatus()) == 6) {
            transaction = null;
            try {
                this._transactionManager.begin();
                transaction = this._transactionManager.getTransaction();
            }
            catch (Exception e) {
                throw RuntimeMessages.MESSAGES.failedCreateNewTransaction(e);
            }
        } else {
            throw RuntimeMessages.MESSAGES.transactionAlreadyExists();
        }
        exchange.getContext().setProperty(INITIATED_TRANSACTION_PROPERTY, (Object)transaction, Scope.EXCHANGE).addLabels(new String[]{BehaviorLabel.TRANSIENT.label()});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void endTransaction() throws HandlerException {
        int txStatus;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"completing transaction");
        }
        if ((txStatus = this.getCurrentTransactionStatus()) == 1) {
            try {
                this._transactionManager.rollback();
                if (!_log.isDebugEnabled()) return;
                _log.debug((Object)"Transaction rolled back as it has been marked as RollbackOnly");
                return;
            }
            catch (Exception e) {
                throw RuntimeMessages.MESSAGES.failedToRollbackTransaction(e);
            }
        }
        if (txStatus != 0) throw RuntimeMessages.MESSAGES.failedToCompleteWithStatus(txStatus);
        try {
            this._transactionManager.commit();
            if (!_log.isDebugEnabled()) return;
            _log.debug((Object)"Transaction has been committed");
            return;
        }
        catch (Exception e) {
            throw RuntimeMessages.MESSAGES.failedToCommitTransaction(e);
        }
    }

    private void suspendTransaction(Exchange exchange) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Suspending active transaction for exchange.");
        }
        Transaction transaction = null;
        try {
            transaction = this._transactionManager.suspend();
        }
        catch (SystemException sysEx) {
            RuntimeLogger.ROOT_LOGGER.failedToSuspendTransactionOnExchange(sysEx);
        }
        if (transaction != null) {
            exchange.getContext().setProperty(SUSPENDED_TRANSACTION_PROPERTY, (Object)transaction, Scope.EXCHANGE).addLabels(new String[]{BehaviorLabel.TRANSIENT.label()});
        }
    }

    private void resumeTransaction(Transaction transaction) {
        try {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Resuming suspended transaction");
            }
            this._transactionManager.resume(transaction);
        }
        catch (Exception ex) {
            RuntimeLogger.ROOT_LOGGER.failedToResumeTransaction(ex);
        }
    }

    private Transaction getCurrentTransaction() throws HandlerException {
        try {
            return this._transactionManager.getTransaction();
        }
        catch (Exception e) {
            throw RuntimeMessages.MESSAGES.failedToRetrieveStatus(e);
        }
    }

    private int getCurrentTransactionStatus() throws HandlerException {
        try {
            return this._transactionManager.getStatus();
        }
        catch (Exception e) {
            throw RuntimeMessages.MESSAGES.failedToRetrieveStatus(e);
        }
    }
}

