/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.security.jboss.credential.extractor;

import java.security.Principal;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;
import javax.servlet.ServletRequest;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.RequestFacade;
import org.jboss.as.web.security.JBossGenericPrincipal;
import org.switchyard.common.type.reflect.Access;
import org.switchyard.common.type.reflect.FieldAccess;
import org.switchyard.security.credential.Credential;
import org.switchyard.security.credential.SubjectCredential;
import org.switchyard.security.credential.extractor.DefaultServletRequestCredentialExtractor;

public class JBossServletRequestCredentialExtractor
extends DefaultServletRequestCredentialExtractor {
    private static final Access<Request> REQUEST_ACCESS;
    private static final Access<Principal> PRINCIPAL_ACCESS;

    public Set<Credential> extract(ServletRequest source) {
        HashSet<Credential> credentials = new HashSet<Credential>();
        if (source != null) {
            Subject subject;
            Principal principal;
            credentials.addAll(super.extract(source));
            Request request = null;
            if (source instanceof Request) {
                request = (Request)source;
            } else if (source instanceof RequestFacade && REQUEST_ACCESS != null) {
                request = (Request)REQUEST_ACCESS.read((Object)((RequestFacade)source));
            }
            if (request != null && PRINCIPAL_ACCESS != null && (principal = (Principal)PRINCIPAL_ACCESS.read((Object)request)) instanceof JBossGenericPrincipal && (subject = ((JBossGenericPrincipal)principal).getSubject()) != null) {
                credentials.add((Credential)new SubjectCredential(subject));
            }
        }
        return credentials;
    }

    static {
        FieldAccess requestAccess = new FieldAccess(RequestFacade.class, "request");
        REQUEST_ACCESS = requestAccess.isReadable() ? requestAccess : null;
        FieldAccess principalAccess = new FieldAccess(Request.class, "userPrincipal");
        PRINCIPAL_ACCESS = principalAccess.isReadable() ? principalAccess : null;
    }
}

