/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.serial.jackson.format;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.ObjectWriter;
import org.codehaus.jackson.map.SerializationConfig;
import org.switchyard.common.io.CountingOutputStream;
import org.switchyard.serial.BaseSerializer;
import org.switchyard.serial.FormatType;

public final class JSONJacksonSerializer
extends BaseSerializer {
    private static final ObjectMapper OBJECT_MAPPER;

    public JSONJacksonSerializer() {
        super(FormatType.JSON);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> int serialize(T obj, Class<T> type, OutputStream out) throws IOException {
        out = new CountingOutputStream((OutputStream)new BufferedOutputStream(out, this.getBufferSize()));
        try {
            ObjectWriter writer = OBJECT_MAPPER.writerWithType(type);
            if (this.isPrettyPrint()) {
                writer = writer.withDefaultPrettyPrinter();
            }
            writer.writeValue(out, obj);
        }
        finally {
            if (this.isCloseEnabled()) {
                out.close();
            }
        }
        return ((CountingOutputStream)out).getCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T deserialize(InputStream in, Class<T> type) throws IOException {
        Object obj;
        try {
            obj = OBJECT_MAPPER.readValue(in, type);
        }
        finally {
            if (this.isCloseEnabled()) {
                in.close();
            }
        }
        return (T)obj;
    }

    static {
        JsonFactory jsonFactory = new JsonFactory();
        jsonFactory.disable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
        jsonFactory.disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
        OBJECT_MAPPER = new ObjectMapper(jsonFactory);
        OBJECT_MAPPER.enableDefaultTyping();
        OBJECT_MAPPER.disable(new SerializationConfig.Feature[]{SerializationConfig.Feature.FAIL_ON_EMPTY_BEANS});
    }
}

