/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.serial.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.switchyard.common.type.Classes;
import org.switchyard.serial.FormatType;
import org.switchyard.serial.Serializer;

public abstract class SerializationProvider {
    private static final Map<FormatType, List<SerializationProvider>> MAP;

    public abstract Set<FormatType> getSupportedFormats();

    public abstract Serializer newSerializer(FormatType var1);

    public static final List<SerializationProvider> getProviders(FormatType format) {
        return MAP.containsKey((Object)format) ? MAP.get((Object)format) : Collections.emptyList();
    }

    public static final SerializationProvider getPrimaryProvider(FormatType format) {
        Iterator<SerializationProvider> providers = SerializationProvider.getProviders(format).iterator();
        return providers.hasNext() ? providers.next() : null;
    }

    static {
        LinkedHashMap<FormatType, List<SerializationProvider>> map = new LinkedHashMap<FormatType, List<SerializationProvider>>();
        ServiceLoader<SerializationProvider> providers = ServiceLoader.load(SerializationProvider.class, Classes.getClassLoader(SerializationProvider.class));
        for (SerializationProvider provider : providers) {
            for (FormatType format : provider.getSupportedFormats()) {
                ArrayList<SerializationProvider> list = (ArrayList<SerializationProvider>)map.get((Object)format);
                if (list == null) {
                    list = new ArrayList<SerializationProvider>();
                    map.put(format, list);
                }
                list.add(provider);
            }
        }
        for (FormatType format : new LinkedHashSet(map.keySet())) {
            map.put(format, Collections.unmodifiableList((List)map.remove((Object)format)));
        }
        MAP = Collections.unmodifiableMap(map);
    }
}

