/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.test;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;

public class MockInitialContextFactory
implements InitialContextFactory {
    private static Context _context;
    private static Map<Object, Object> _boundObjects;

    public static void install() {
        if (System.getProperty("java.naming.factory.initial") == null) {
            System.setProperty("java.naming.factory.initial", MockInitialContextFactory.class.getName());
        }
    }

    public static void clear() {
        _boundObjects.clear();
    }

    @Override
    public Context getInitialContext(Hashtable<?, ?> environment) throws NamingException {
        if (_context == null) {
            _context = (Context)Proxy.newProxyInstance(Context.class.getClassLoader(), new Class[]{Context.class}, (InvocationHandler)new ContextInvocationHandler());
        }
        return _context;
    }

    static {
        _boundObjects = new HashMap<Object, Object>();
    }

    class ContextInvocationHandler
    implements InvocationHandler {
        ContextInvocationHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (methodName.equals("bind") && args.length == 2) {
                _boundObjects.put(args[0], args[1]);
                return null;
            }
            if (methodName.equals("lookup") && args.length == 1) {
                Object object = _boundObjects.get(args[0]);
                if (object != null) {
                    return object;
                }
                throw new NamingException("Unknown object name '" + args[0] + "'.");
            }
            if (methodName.equals("close")) {
                return true;
            }
            throw new NamingException("Unexpected call to '" + method.getName() + "'.");
        }
    }
}

