/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.test;

import javax.xml.namespace.QName;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.switchyard.ExchangeHandler;
import org.switchyard.ServiceDomain;
import org.switchyard.deploy.internal.AbstractDeployment;
import org.switchyard.metadata.InOnlyService;
import org.switchyard.metadata.InOutService;
import org.switchyard.metadata.ServiceInterface;
import org.switchyard.test.Invoker;
import org.switchyard.test.MockHandler;
import org.switchyard.transform.Transformer;

public abstract class SwitchYardTestCase {
    private AbstractDeployment _deployment;

    @Before
    public void deploy() throws Exception {
        if (this._deployment == null) {
            this._deployment = this.createDeployment();
            this._deployment.init();
        }
    }

    @After
    public void undeploy() {
        this.assertDeployed();
        this._deployment.destroy();
    }

    protected AbstractDeployment createDeployment() throws Exception {
        return new AbstractDeployment(){

            public void destroy() {
            }
        };
    }

    public ServiceDomain getServiceDomain() {
        this.assertDeployed();
        return this._deployment.getDomain();
    }

    protected MockHandler registerInOutService(String serviceName) {
        MockHandler handler = new MockHandler();
        this.getServiceDomain().registerService(new QName(serviceName), (ExchangeHandler)handler, (ServiceInterface)new InOutService());
        return handler;
    }

    protected void registerInOutService(String serviceName, ExchangeHandler serviceHandler) {
        this.getServiceDomain().registerService(new QName(serviceName), serviceHandler, (ServiceInterface)new InOutService());
    }

    protected MockHandler registerInOnlyService(String serviceName) {
        MockHandler handler = new MockHandler();
        this.getServiceDomain().registerService(new QName(serviceName), (ExchangeHandler)handler, (ServiceInterface)new InOnlyService());
        return handler;
    }

    protected void registerInOnlyService(String serviceName, ExchangeHandler serviceHandler) {
        this.getServiceDomain().registerService(new QName(serviceName), serviceHandler, (ServiceInterface)new InOnlyService());
    }

    public void addTransformer(Transformer transformer) {
        this.getServiceDomain().getTransformerRegistry().addTransformer(transformer);
    }

    protected Invoker newInvoker(QName serviceName) {
        return new Invoker(this.getServiceDomain(), serviceName);
    }

    protected Invoker newInvoker(String serviceName) {
        return new Invoker(this.getServiceDomain(), serviceName);
    }

    private void assertDeployed() {
        if (this._deployment == null) {
            Assert.fail((String)"TestCase deployment not yet deployed.  You may need to make an explicit call to the deploy() method.");
        }
    }
}

