/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.test.mixins;

import java.lang.annotation.Annotation;
import javax.naming.NamingException;
import org.jboss.weld.environment.se.Weld;
import org.jboss.weld.environment.se.WeldContainer;
import org.jboss.weld.environment.se.events.ContainerInitialized;
import org.junit.Assert;
import org.switchyard.common.type.Classes;
import org.switchyard.deploy.ServiceDomainManager;
import org.switchyard.deploy.internal.AbstractDeployment;
import org.switchyard.test.MockInitialContextFactory;
import org.switchyard.test.SimpleTestDeployment;
import org.switchyard.test.mixins.AbstractTestMixIn;

public class CDIMixIn
extends AbstractTestMixIn {
    private Weld _weld;
    private AbstractDeployment _simpleCdiDeployment;

    @Override
    public void initialize() {
        this._weld = new Weld();
        WeldContainer weldContainer = this._weld.initialize();
        weldContainer.event().select(ContainerInitialized.class, new Annotation[0]).fire((Object)new ContainerInitialized());
        try {
            MockInitialContextFactory.getJavaComp().bind("BeanManager", (Object)weldContainer.getBeanManager());
        }
        catch (NamingException e) {
            Assert.fail((String)"Failed to bind BeanManager into 'java:comp'.");
        }
    }

    @Override
    public void before(AbstractDeployment deployment) {
        if (deployment instanceof SimpleTestDeployment) {
            Class simpleCdiDeploymentType = Classes.forName((String)"org.switchyard.component.bean.internal.SimpleCDIDeployment", this.getClass());
            if (simpleCdiDeploymentType == null) {
                Assert.fail((String)"Failed to locate the SimpleCDIDeployment class on the classpath.  Module must include the SwitchYard Bean Component as one of its depedencies.");
            }
            try {
                this._simpleCdiDeployment = (AbstractDeployment)simpleCdiDeploymentType.newInstance();
                this._simpleCdiDeployment.setParentDeployment(deployment);
                this._simpleCdiDeployment.init(ServiceDomainManager.createDomain());
                this._simpleCdiDeployment.start();
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)("Failed to manually deploy Bean Service.  Exception: " + e.getMessage()));
            }
        }
    }

    @Override
    public void after(AbstractDeployment deployment) {
        if (this._simpleCdiDeployment != null) {
            this._simpleCdiDeployment.stop();
            this._simpleCdiDeployment.destroy();
        }
    }

    @Override
    public void uninitialize() {
        this._weld.shutdown();
    }
}

