/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.test.mixins;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.junit.Assert;
import org.switchyard.test.mixins.AbstractTestMixIn;

public class HTTPMixIn
extends AbstractTestMixIn {
    private HttpClient _httpClient;
    private String _contentType = "text/xml";

    public HTTPMixIn setContentType(String contentType) {
        this._contentType = contentType;
        return this;
    }

    @Override
    public void initialize() {
        this._httpClient = new HttpClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String postString(String endpointURL, String request) {
        PostMethod postMethod = new PostMethod(endpointURL);
        try {
            postMethod.setRequestEntity((RequestEntity)new StringRequestEntity(request, this._contentType, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        try {
            String string = this.execute((HttpMethod)postMethod);
            return string;
        }
        finally {
            postMethod.releaseConnection();
        }
    }

    public String postStringAndTestXML(String endpointURL, String request, String expectedResponse) {
        String response = this.postString(endpointURL, request);
        this.getTestCase().compareXMLToString(response, expectedResponse);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String postResource(String endpointURL, String requestResource) {
        PostMethod postMethod = new PostMethod(endpointURL);
        InputStream requestStream = this.getTestCase().getResourceAsStream(requestResource);
        try {
            postMethod.setRequestEntity((RequestEntity)new InputStreamRequestEntity(requestStream, this._contentType + "; charset=utf-8"));
            String string = this.execute((HttpMethod)postMethod);
            return string;
        }
        finally {
            try {
                requestStream.close();
            }
            catch (IOException e) {
                Assert.fail((String)"Unexpected exception closing HTTP request resource stream.");
            }
            finally {
                postMethod.releaseConnection();
            }
        }
    }

    public String postResourceAndTestXML(String endpointURL, String requestResource, String expectedResponseResource) {
        String response = this.postResource(endpointURL, requestResource);
        this.getTestCase().compareXMLToResource(response, expectedResponseResource);
        return response;
    }

    public String execute(HttpMethod method) {
        try {
            this._httpClient.executeMethod(method);
            return method.getResponseBodyAsString();
        }
        catch (Exception e) {
            try {
                Assert.fail((String)("Exception invoking HTTP endpoint '" + method.getURI() + "': " + e.getMessage()));
            }
            catch (URIException e1) {
                e1.printStackTrace();
            }
            return null;
        }
    }
}

