/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.test;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.InitializationError;
import org.switchyard.ExchangeHandler;
import org.switchyard.ServiceDomain;
import org.switchyard.common.type.Classes;
import org.switchyard.common.type.classpath.ClasspathScanner;
import org.switchyard.config.model.MergeScanner;
import org.switchyard.config.model.Model;
import org.switchyard.config.model.ModelResource;
import org.switchyard.config.model.Models;
import org.switchyard.config.model.Scannable;
import org.switchyard.config.model.Scanner;
import org.switchyard.config.model.ScannerInput;
import org.switchyard.config.model.ScannerOutput;
import org.switchyard.config.model.switchyard.SwitchYardModel;
import org.switchyard.config.model.switchyard.v1.V1SwitchYardModel;
import org.switchyard.config.model.transform.TransformModel;
import org.switchyard.deploy.ServiceDomainManager;
import org.switchyard.deploy.internal.AbstractDeployment;
import org.switchyard.deploy.internal.Deployment;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.metadata.InOnlyService;
import org.switchyard.metadata.InOutService;
import org.switchyard.metadata.ServiceInterface;
import org.switchyard.test.Invoker;
import org.switchyard.test.MockHandler;
import org.switchyard.test.MockInitialContextFactory;
import org.switchyard.test.SimpleTestDeployment;
import org.switchyard.test.SwitchYardTestCaseConfig;
import org.switchyard.test.TestMixIn;
import org.switchyard.test.mixins.AbstractTestMixIn;
import org.switchyard.transform.BaseTransformer;
import org.switchyard.transform.Transformer;
import org.switchyard.transform.config.model.TransformerFactory;
import org.w3c.dom.Document;

@RunWith(value=TestRunner.class)
public abstract class SwitchYardTestCase {
    private static Logger _logger = Logger.getLogger(SwitchYardTestCase.class);
    protected static final String NULL_CONFIG = "$$NULL_SW_CONFIG$$";
    private SwitchYardModel _configModel;
    private AbstractDeployment _deployment;
    private List<Class<? extends TestMixIn>> _testMixIns;
    private List<TestMixIn> _testMixInInstances = new ArrayList<TestMixIn>();
    private static final ThreadLocal<TestRunner> TEST_RUNNER = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SwitchYardTestCase() {
        SwitchYardTestCaseConfig testCaseConfig = this.getClass().getAnnotation(SwitchYardTestCaseConfig.class);
        if (testCaseConfig != null) {
            Class<? extends TestMixIn>[] testMixIns;
            String config = testCaseConfig.config();
            if (config != null && !config.equals(NULL_CONFIG)) {
                InputStream is = null;
                try {
                    is = this.getResourceAsStream(config);
                    this._configModel = this.createSwitchYardModel(is, this.createScanners(testCaseConfig));
                }
                finally {
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (Throwable t) {
                        t.getMessage();
                    }
                }
            }
            if ((testMixIns = testCaseConfig.mixins()) == null) {
                _logger.debug((Object)"No TestMixIns for test.");
            } else if (testMixIns.length == 1 && testMixIns[0] == NullMixIns.class) {
                _logger.debug((Object)"No TestMixIns for test.");
            } else {
                this._testMixIns = Arrays.asList(testMixIns);
            }
        }
        MockInitialContextFactory.install();
        this.createMixInInstances();
        this.initializeMixIns();
        SwitchYardTestCase.TEST_RUNNER.get().setTestCase(this);
    }

    private void cleanup() {
        this.cleanupMixIns();
        MockInitialContextFactory.clear();
    }

    public SwitchYardTestCase(InputStream configModel) {
        SwitchYardTestCaseConfig testCaseConfig = this.getClass().getAnnotation(SwitchYardTestCaseConfig.class);
        this._configModel = this.createSwitchYardModel(configModel, this.createScanners(testCaseConfig));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SwitchYardTestCase(String configModelPath) {
        Assert.assertNotNull((String)"Test 'configModel' is null.", (Object)configModelPath);
        SwitchYardTestCaseConfig testCaseConfig = this.getClass().getAnnotation(SwitchYardTestCaseConfig.class);
        InputStream is = null;
        try {
            is = this.getResourceAsStream(configModelPath);
            this._configModel = this.createSwitchYardModel(is, this.createScanners(testCaseConfig));
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Throwable t) {
                t.getMessage();
            }
        }
    }

    public SwitchYardTestCase(SwitchYardModel configModel) {
        Assert.assertNotNull((String)"Test 'configModel' is null.", (Object)configModel);
        this._configModel = configModel;
    }

    public SwitchYardModel getConfigModel() {
        return this._configModel;
    }

    @Before
    public final void deploy() throws Exception {
        this._deployment = this.createDeployment();
        this._deployment.init(ServiceDomainManager.createDomain());
        this.mixInBefore();
        this._deployment.start();
    }

    @After
    public final void undeploy() {
        this.assertDeployed();
        this._deployment.stop();
        this.mixInAfter();
        this._deployment.destroy();
    }

    protected AbstractDeployment createDeployment() throws Exception {
        if (this._configModel != null) {
            return new Deployment(this._configModel);
        }
        return new SimpleTestDeployment();
    }

    public AbstractDeployment getDeployment() {
        return this._deployment;
    }

    public ServiceDomain getServiceDomain() {
        this.assertDeployed();
        return this._deployment.getDomain();
    }

    protected MockHandler registerInOutService(String serviceName) {
        MockHandler handler = new MockHandler();
        this.getServiceDomain().registerService(QName.valueOf(serviceName), (ExchangeHandler)handler, (ServiceInterface)new InOutService());
        return handler;
    }

    protected void registerInOutService(String serviceName, ExchangeHandler serviceHandler) {
        this.getServiceDomain().registerService(QName.valueOf(serviceName), serviceHandler, (ServiceInterface)new InOutService());
    }

    protected void registerInOutService(String serviceName, ExchangeHandler serviceHandler, ServiceInterface metadata) {
        this.getServiceDomain().registerService(QName.valueOf(serviceName), serviceHandler, metadata);
    }

    protected MockHandler registerInOnlyService(String serviceName) {
        MockHandler handler = new MockHandler();
        this.getServiceDomain().registerService(QName.valueOf(serviceName), (ExchangeHandler)handler, (ServiceInterface)new InOnlyService());
        return handler;
    }

    protected void registerInOnlyService(String serviceName, ExchangeHandler serviceHandler) {
        this.getServiceDomain().registerService(QName.valueOf(serviceName), serviceHandler, (ServiceInterface)new InOnlyService());
    }

    public void addTransformer(Transformer transformer) {
        this.getServiceDomain().getTransformerRegistry().addTransformer(transformer);
    }

    protected Invoker newInvoker(QName serviceName) {
        return new Invoker(this.getServiceDomain(), serviceName);
    }

    protected Invoker newInvoker(String serviceName) {
        return new Invoker(this.getServiceDomain(), serviceName);
    }

    public Transformer newTransformer(TransformModel transformModel) {
        return TransformerFactory.newTransformer((TransformModel)transformModel);
    }

    public Transformer registerTransformer(TransformModel transformModel) {
        Object transformer;
        if (transformModel.getFrom() == null || transformModel.getTo() == null) {
            Assert.fail((String)"Invalid TransformModel instance.  Must specify 'from' and 'to' data types.");
        }
        if ((transformer = TransformerFactory.newTransformer((TransformModel)transformModel)).getFrom() == null) {
            transformer = new TransformerWrapper((Transformer)transformer, transformModel);
        }
        this._deployment.getDomain().getTransformerRegistry().removeTransformer(transformer);
        return transformer;
    }

    public <T extends TestMixIn> T getMixIn(Class<T> type) {
        int indexOf;
        if (this._testMixIns == null || this._testMixIns.isEmpty()) {
            Assert.fail((String)"No TestMixIns specified on Test class instance.  Use the @TestMixIns annotation.");
        }
        if (this._testMixIns.size() != this._testMixInInstances.size()) {
            Assert.fail((String)"TestMixIn instances only available during test method execution.");
        }
        if ((indexOf = this._testMixIns.indexOf(type)) == -1) {
            Assert.fail((String)("Required TestMixIn '" + type.getName() + "' is not specified on TestCase '" + this.getClass().getName() + "'."));
        }
        return (T)((TestMixIn)type.cast(this._testMixInInstances.get(indexOf)));
    }

    public InputStream getResourceAsStream(String name) {
        try {
            return Classes.getResourceAsStream((String)name, this.getClass());
        }
        catch (IOException ioe) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readResourceBytes(String path) {
        InputStream resourceStream;
        if (path == null) {
            Assert.fail((String)"Resource 'path' not specified.");
        }
        if ((resourceStream = this.getResourceAsStream(path)) == null) {
            Assert.fail((String)("Resource '" + path + "' not found on classpath relative to test class '" + this.getClass().getName() + "'.  May need to fix the relative path, or make the path absolute."));
        }
        ByteArrayOutputStream byteOutStream = new ByteArrayOutputStream();
        try {
            byte[] readBuffer = new byte[128];
            int readCount = 0;
            while ((readCount = resourceStream.read(readBuffer)) != -1) {
                byteOutStream.write(readBuffer, 0, readCount);
            }
        }
        catch (IOException e) {
            Assert.fail((String)("Unexpected read error reading classpath resource '" + path + "'" + e.getMessage()));
        }
        finally {
            try {
                resourceStream.close();
            }
            catch (IOException e) {
                Assert.fail((String)("Unexpected exception closing classpath resource '" + path + "'" + e.getMessage()));
            }
        }
        return byteOutStream.toByteArray();
    }

    public String readResourceString(String path) {
        try {
            return new String(this.readResourceBytes(path), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Assert.fail((String)("Unexpected exception reading classpath resource '" + path + "' as a String.  Perhaps this resource is a binary resource that cannot be encoded as a String." + e.getMessage()));
            return null;
        }
    }

    public Document readResourceDocument(String path) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            return db.parse(this.getResourceAsStream(path));
        }
        catch (Exception e) {
            Assert.fail((String)("Unexpected exception reading classpath resource '" + path + "' as a DOM Document." + e.getMessage()));
            return null;
        }
    }

    public SwitchYardModel loadSwitchYardModel(InputStream configModel) {
        return this.loadConfigModel(configModel, SwitchYardModel.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <M extends Model> M loadConfigModel(InputStream configModel, Class<M> modelType) {
        if (configModel == null) {
            throw new IllegalArgumentException("null 'configModel' arg.");
        }
        try {
            Model model = new ModelResource().pull(configModel);
            return (M)model;
        }
        catch (IOException e) {
            Assert.fail((String)("Unexpected error building " + modelType.getSimpleName() + ": " + e.getMessage()));
        }
        finally {
            try {
                configModel.close();
            }
            catch (IOException e) {
                Assert.fail((String)("Unexpected error closing " + modelType.getSimpleName() + " stream: " + e.getMessage()));
            }
        }
        return null;
    }

    public void compareXMLToResource(String xml, String resourcePath) {
        XMLUnit.setIgnoreWhitespace((boolean)true);
        try {
            XMLAssert.assertXMLEqual((String)this.readResourceString(resourcePath), (String)xml);
        }
        catch (Exception e) {
            Assert.fail((String)("Unexpected error performing XML comparison: " + e.getMessage()));
        }
    }

    public void compareXMLToString(String xml, String string) {
        XMLUnit.setIgnoreWhitespace((boolean)true);
        try {
            XMLAssert.assertXMLEqual((String)string, (String)xml);
        }
        catch (Exception e) {
            Assert.fail((String)"Unexpected error performing XML comparison.");
        }
    }

    private void initializeMixIns() {
        for (TestMixIn mixIn : this._testMixInInstances) {
            mixIn.initialize();
        }
    }

    private void mixInBefore() {
        for (TestMixIn mixIn : this._testMixInInstances) {
            mixIn.before(this._deployment);
        }
    }

    private void mixInAfter() {
        for (int i = this._testMixInInstances.size() - 1; i >= 0; --i) {
            this._testMixInInstances.get(i).after(this._deployment);
        }
    }

    private void cleanupMixIns() {
        for (int i = this._testMixInInstances.size() - 1; i >= 0; --i) {
            this._testMixInInstances.get(i).uninitialize();
        }
    }

    private void createMixInInstances() {
        this._testMixInInstances.clear();
        if (this._testMixIns == null || this._testMixIns.isEmpty()) {
            return;
        }
        for (Class<? extends TestMixIn> mixInType : this._testMixIns) {
            try {
                TestMixIn testMixIn = mixInType.newInstance();
                testMixIn.setTestCase(this);
                this._testMixInInstances.add(testMixIn);
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)("Failed to create instance of TestMixIn type " + mixInType.getName() + ".  Make sure it defines a public default constructor."));
            }
        }
    }

    private SwitchYardModel createSwitchYardModel(InputStream configModel, List<Scanner<V1SwitchYardModel>> scanners) {
        Assert.assertNotNull((String)"Test 'configModel' is null.", (Object)configModel);
        try {
            SwitchYardModel model = this.loadSwitchYardModel(configModel);
            ClassLoader classLoader = this.getClass().getClassLoader();
            if (scanners != null && !scanners.isEmpty() && classLoader instanceof URLClassLoader) {
                MergeScanner merge_scanner = new MergeScanner(V1SwitchYardModel.class, true, scanners);
                List<URL> scanURLs = this.getScanURLs((URLClassLoader)classLoader);
                ScannerInput scanner_input = new ScannerInput().setName("").setURLs(scanURLs);
                V1SwitchYardModel scannedModel = (V1SwitchYardModel)merge_scanner.scan(scanner_input).getModel();
                return (SwitchYardModel)Models.merge((Model)scannedModel, (Model)model, (boolean)false);
            }
            return model;
        }
        catch (IOException ioEx) {
            throw new SwitchYardException("Failed to read switchyard config.", (Throwable)ioEx);
        }
    }

    private void assertDeployed() {
        if (this._deployment == null) {
            Assert.fail((String)"TestCase deployment not yet deployed.  You may need to make an explicit call to the deploy() method.");
        }
    }

    private List<Scanner<V1SwitchYardModel>> createScanners(SwitchYardTestCaseConfig testCaseConfig) {
        ArrayList<Scanner<V1SwitchYardModel>> scanners = new ArrayList<Scanner<V1SwitchYardModel>>();
        if (testCaseConfig != null) {
            Class<? extends Scanner>[] scannerClasses = testCaseConfig.scanners();
            if (scannerClasses == null) {
                _logger.debug((Object)"No Scanners for test.");
            } else if (scannerClasses.length == 1 && scannerClasses[0] == NullScanners.class) {
                _logger.debug((Object)"No Scanners for test.");
            } else {
                for (Class<? extends Scanner> scannerClass : scannerClasses) {
                    try {
                        scanners.add((Scanner<V1SwitchYardModel>)scannerClass.newInstance());
                    }
                    catch (Exception e) {
                        Assert.fail((String)("Exception creating instance of Scanner class '" + scannerClass.getName() + "': " + e.getMessage()));
                    }
                }
            }
        }
        return scanners;
    }

    private List<URL> getScanURLs(URLClassLoader classLoader) {
        URL[] classPathURLs = classLoader.getURLs();
        ArrayList<URL> scanURLs = new ArrayList<URL>();
        for (URL classpathURL : classPathURLs) {
            try {
                File file = ClasspathScanner.toClassPathFile((URL)classpathURL);
                if (!file.isDirectory()) continue;
                scanURLs.add(classpathURL);
            }
            catch (IOException e) {
                Assert.fail((String)("Failed to convert classpath URL '" + classpathURL + "' to a File instance."));
            }
        }
        return scanURLs;
    }

    protected static final class NullMixIns
    extends AbstractTestMixIn {
        protected NullMixIns() {
        }
    }

    protected static final class NullScanners
    implements Scanner {
        protected NullScanners() {
        }

        public ScannerOutput scan(ScannerInput scannerInput) throws IOException {
            return null;
        }
    }

    protected static class TestRunner
    extends BlockJUnit4ClassRunner {
        private SwitchYardTestCase _testCase;

        public TestRunner(Class<?> klass) throws InitializationError {
            super(klass);
        }

        private void setTestCase(SwitchYardTestCase testCase) {
            this._testCase = testCase;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(RunNotifier notifier) {
            try {
                TEST_RUNNER.set(this);
                super.run(notifier);
            }
            finally {
                try {
                    this._testCase.cleanup();
                }
                finally {
                    TEST_RUNNER.remove();
                }
            }
        }
    }

    @Scannable(value=false)
    private static final class TransformerWrapper
    extends BaseTransformer {
        private Transformer _transformer;
        private TransformModel _transformModel;

        private TransformerWrapper(Transformer transformer, TransformModel transformModel) {
            this._transformer = transformer;
            this._transformModel = transformModel;
        }

        public Object transform(Object from) {
            return this._transformer.transform(from);
        }

        public QName getFrom() {
            return this._transformModel.getFrom();
        }

        public QName getTo() {
            return this._transformModel.getTo();
        }
    }
}

