/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.test;

import java.lang.reflect.Field;
import org.junit.Assert;
import org.junit.runner.Description;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.InitializationError;
import org.switchyard.test.Invoker;
import org.switchyard.test.ServiceOperation;
import org.switchyard.test.SwitchYardTestKit;
import org.switchyard.test.TestMixIn;

public class SwitchYardRunner
extends BlockJUnit4ClassRunner {
    private SwitchYardTestKit _testKit;
    private Object _testInstance;

    public SwitchYardRunner(Class<?> clazz) throws InitializationError {
        super(clazz);
    }

    protected Object createTest() throws Exception {
        this._testInstance = super.createTest();
        this._testKit = new SwitchYardTestKit(this._testInstance);
        for (TestMixIn mixIn : this._testKit.getMixIns()) {
            this.set(mixIn, PropertyMatchResolution.EQUALS);
        }
        this._testKit.start();
        this.set(this._testKit, PropertyMatchResolution.EQUALS);
        this.set(this._testKit.getDeployment(), PropertyMatchResolution.ASSIGNABLE);
        this.set(this._testKit.getConfigModel(), PropertyMatchResolution.ASSIGNABLE);
        this.set(this._testKit.getServiceDomain(), PropertyMatchResolution.ASSIGNABLE);
        this.set(this._testKit.getServiceDomain().getTransformerRegistry(), PropertyMatchResolution.ASSIGNABLE);
        this.set(this._testKit.getServiceDomain().getProperties().get("CamelContextProperty"), PropertyMatchResolution.ASSIGNABLE);
        this.setInvokers();
        return this._testInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(RunNotifier notifier) {
        TestLifecycleListener listener = new TestLifecycleListener();
        notifier.addListener((RunListener)listener);
        try {
            super.run(notifier);
        }
        finally {
            notifier.removeListener((RunListener)listener);
        }
    }

    private void set(Object propertyValue, PropertyMatchResolution matchRes) throws IllegalAccessException {
        Field[] fields;
        for (Field field : fields = this._testInstance.getClass().getDeclaredFields()) {
            if (matchRes == PropertyMatchResolution.ASSIGNABLE) {
                if (!field.getType().isInstance(propertyValue)) continue;
                this.set(field, propertyValue);
                continue;
            }
            if (matchRes != PropertyMatchResolution.EQUALS || field.getType() != propertyValue.getClass()) continue;
            this.set(field, propertyValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void set(Field field, Object propertyValue) throws IllegalAccessException {
        boolean accessible = field.isAccessible();
        field.setAccessible(true);
        try {
            field.set(this._testInstance, propertyValue);
        }
        finally {
            field.setAccessible(accessible);
        }
    }

    private void setInvokers() throws IllegalAccessException {
        Field[] fields;
        for (Field field : fields = this._testInstance.getClass().getDeclaredFields()) {
            Invoker invoker;
            if (field.getType() != Invoker.class) continue;
            ServiceOperation serviceOp = field.getAnnotation(ServiceOperation.class);
            if (serviceOp == null) {
                Assert.fail((String)("Invoker property '" + field.getName() + "' on test class '" + this._testInstance.getClass().getName() + "' needs to be annotated with a @ServiceOperation."));
            }
            if ((invoker = this._testKit.newInvoker(serviceOp.value())) == null) {
                Assert.fail((String)("Invoker property '" + field.getName() + "' on test class '" + this._testInstance.getClass().getName() + "' contains an a @ServiceOperation defining an unknown Service Operation value '" + serviceOp.value() + "'."));
            }
            this.set(field, invoker);
        }
    }

    private static enum PropertyMatchResolution {
        ASSIGNABLE,
        EQUALS;

    }

    private class TestLifecycleListener
    extends RunListener {
        private TestLifecycleListener() {
        }

        public void testFinished(Description description) throws Exception {
            SwitchYardRunner.this._testKit.cleanup();
        }
    }
}

