/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.transform.xslt;

import java.io.Reader;
import java.io.StringWriter;
import javax.xml.namespace.QName;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;
import org.switchyard.Message;
import org.switchyard.config.model.Scannable;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.transform.BaseTransformer;

@Scannable(value=false)
public class XsltTransformer<F, T>
extends BaseTransformer<Message, Message> {
    private static final Logger LOGGER = Logger.getLogger(XsltTransformer.class);
    private Templates _templates;
    private boolean _failOnWarning;

    public XsltTransformer(QName from, QName to, Templates templates, boolean failOnWarning) {
        super(from, to);
        this._templates = templates;
        this._failOnWarning = failOnWarning;
    }

    public Message transform(Message message) {
        try {
            StreamSource source = new StreamSource((Reader)message.getContent(Reader.class));
            StringWriter resultWriter = new StringWriter();
            StreamResult result = new StreamResult(resultWriter);
            Transformer transformer = this._templates.newTransformer();
            transformer.setErrorListener(new XsltTransformerErrorListener(this._failOnWarning));
            transformer.transform(source, result);
            message.setContent((Object)resultWriter.toString());
        }
        catch (Exception e) {
            throw new SwitchYardException("Error during xslt transformation", (Throwable)e);
        }
        return message;
    }

    private class XsltTransformerErrorListener
    implements ErrorListener {
        private boolean _failOnWarning;

        public XsltTransformerErrorListener(boolean failOnWarning) {
            this._failOnWarning = failOnWarning;
        }

        @Override
        public void warning(TransformerException ex) throws TransformerException {
            if (this._failOnWarning) {
                throw ex;
            }
            LOGGER.warn((Object)"Warning during xslt transformation", (Throwable)ex);
        }

        @Override
        public void error(TransformerException ex) throws TransformerException {
            throw ex;
        }

        @Override
        public void fatalError(TransformerException ex) throws TransformerException {
            throw ex;
        }
    }
}

