/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.transform.jaxb.internal;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.switchyard.Message;
import org.switchyard.SwitchYardException;
import org.switchyard.common.xml.QNameUtil;
import org.switchyard.config.model.Scannable;
import org.switchyard.transform.BaseTransformer;

@Scannable(value=false)
public class JAXBUnmarshalTransformer<F, T>
extends BaseTransformer<Message, Message> {
    private JAXBContext _jaxbContext;

    public JAXBUnmarshalTransformer(QName from, QName to, String contextPath) throws SwitchYardException {
        super(from, to);
        try {
            this._jaxbContext = contextPath != null ? JAXBContext.newInstance((String)contextPath) : JAXBContext.newInstance((Class[])new Class[]{QNameUtil.toJavaMessageType((QName)to)});
        }
        catch (JAXBException e) {
            throw new SwitchYardException("Failed to create JAXBContext for '" + to + "'.", (Throwable)e);
        }
    }

    public Message transform(Message message) {
        Unmarshaller unmarshaller;
        try {
            unmarshaller = this._jaxbContext.createUnmarshaller();
        }
        catch (JAXBException e) {
            throw new SwitchYardException("Failed to create Unmarshaller for '" + this.getTo() + "'.", (Throwable)e);
        }
        try {
            Object unmarshalledObject = unmarshaller.unmarshal((Source)message.getContent(Source.class));
            if (unmarshalledObject instanceof JAXBElement) {
                message.setContent(((JAXBElement)unmarshalledObject).getValue());
            } else {
                message.setContent(unmarshalledObject);
            }
        }
        catch (JAXBException e) {
            throw new SwitchYardException("Failed to unmarshall for '" + this.getTo() + "'.", (Throwable)e);
        }
        return message;
    }
}

