/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.transform.json.internal;

import javax.xml.namespace.QName;
import org.codehaus.jackson.map.ObjectMapper;
import org.switchyard.ServiceDomain;
import org.switchyard.common.xml.QNameUtil;
import org.switchyard.transform.Transformer;
import org.switchyard.transform.config.model.JSONTransformModel;
import org.switchyard.transform.internal.TransformMessages;
import org.switchyard.transform.internal.TransformerFactory;
import org.switchyard.transform.json.internal.JSON2JavaTransformer;
import org.switchyard.transform.json.internal.Java2JSONTransformer;

public final class JSONTransformFactory
implements TransformerFactory<JSONTransformModel> {
    @Override
    public Transformer newTransformer(ServiceDomain domain, JSONTransformModel model) {
        QName from = model.getFrom();
        QName to = model.getTo();
        JSONTransformFactory.assertValidJSONTransformSpec(from, to);
        if (QNameUtil.isJavaMessageType((QName)from)) {
            Class clazz = JSONTransformFactory.toJavaMessageType(from);
            return new Java2JSONTransformer(from, to, new ObjectMapper(), clazz);
        }
        Class clazz = JSONTransformFactory.toJavaMessageType(to);
        return new JSON2JavaTransformer(from, to, new ObjectMapper(), clazz);
    }

    private static Class toJavaMessageType(QName name) {
        Class clazz = QNameUtil.toJavaMessageType((QName)name);
        if (clazz == null) {
            throw TransformMessages.MESSAGES.notAbleToFindClassDefinition(name.toString());
        }
        return clazz;
    }

    private static void assertValidJSONTransformSpec(QName from, QName to) {
        if (QNameUtil.isJavaMessageType((QName)from)) {
            if (QNameUtil.isJavaMessageType((QName)to)) {
                JSONTransformFactory.throwInvalidToFromSpecException();
            }
        } else if (QNameUtil.isJavaMessageType((QName)to)) {
            if (QNameUtil.isJavaMessageType((QName)from)) {
                JSONTransformFactory.throwInvalidToFromSpecException();
            }
        } else {
            JSONTransformFactory.throwInvalidToFromSpecException();
        }
    }

    private static void throwInvalidToFromSpecException() {
        throw TransformMessages.MESSAGES.onlyOneJavaType();
    }
}

