/*
 * Decompiled with CFR 0.152.
 */
package Task.ProgressMonitor;

import Task.ProgressMonitor.UIHookIF;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.HttpURLConnection;

public class InputStreamUIHookSupport
extends FilterInputStream {
    private UIHookIF _uiHook;
    private int _nread = 0;
    private int _size = 0;
    private Type _type;

    public InputStreamUIHookSupport(Type type, UIHookIF uiHook, InputStream in) {
        super(in);
        this._type = type;
        try {
            this._size = in.available();
        }
        catch (IOException ioe) {
            this._size = 0;
        }
        this._uiHook = uiHook;
    }

    public InputStreamUIHookSupport(Type type, UIHookIF uiHook, HttpURLConnection method) throws IOException {
        super(method.getInputStream());
        this._type = type;
        this._size = method.getContentLength();
        if (this._size < 0) {
            this._size = 0;
        }
        this._uiHook = uiHook;
    }

    public UIHookIF getUIHook() {
        return this._uiHook;
    }

    private void _setProgress(int bytesProcessed) {
        if (this._uiHook != null) {
            switch (this._type) {
                case RecvStatus: {
                    this._uiHook.updateRecieveStatus(bytesProcessed, this._size);
                    break;
                }
                case SendStatus: {
                    this._uiHook.updateSendStatus(bytesProcessed, this._size);
                }
            }
        }
    }

    private boolean _isCanceled() {
        if (this._uiHook != null) {
            return this._uiHook.isCancelled();
        }
        return false;
    }

    private void _close() {
        if (this._uiHook != null) {
            this._uiHook.close();
        }
    }

    private void _interruptedIO() {
        if (this._uiHook != null) {
            this._uiHook.interrupedIO();
        }
    }

    public int read() throws IOException {
        int c = this.in.read();
        if (c >= 0) {
            this._setProgress(++this._nread);
        }
        this._checkCancelled();
        return c;
    }

    public int read(byte[] b) throws IOException {
        int nr = this.in.read(b);
        if (nr > 0) {
            this._setProgress(this._nread += nr);
        }
        this._checkCancelled();
        return nr;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int nr = this.in.read(b, off, len);
        if (nr > 0) {
            this._setProgress(this._nread += nr);
        }
        this._checkCancelled();
        return nr;
    }

    private void _checkCancelled() throws IOException {
        if (this._isCanceled()) {
            InterruptedIOException exc = new InterruptedIOException("IO operation cancelled");
            exc.bytesTransferred = this._nread;
            this._interruptedIO();
            throw exc;
        }
    }

    public long skip(long n) throws IOException {
        long nr = this.in.skip(n);
        if (nr > 0L) {
            this._nread = (int)((long)this._nread + nr);
            this._setProgress(this._nread);
        }
        return nr;
    }

    public void close() throws IOException {
        this.in.close();
        this._close();
    }

    public synchronized void reset() throws IOException {
        this.in.reset();
        this._nread = this._size - this.in.available();
        this._setProgress(this._nread);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        SendStatus,
        RecvStatus;

    }
}

