/*
 * Decompiled with CFR 0.152.
 */
package Task.Support.EnhancedListeners;

import Task.Support.EnhancedListeners.EnhancedListener;
import Task.Support.EnhancedListeners.ExecutionDelegate;
import Task.Support.GUISupport.ThreadUtils;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EnhancedListenerUpdater<EventType, EnhancedListenerType extends EnhancedListener> {
    EnhancedListenerUpdater(List<EnhancedListenerType> listenerList, ExecutionDelegate<EventType, EnhancedListenerType> delegate, EventType event) {
        ArrayList<EventType> eventlist = new ArrayList<EventType>();
        eventlist.add(event);
        this._fireUpdate(listenerList, delegate, eventlist);
    }

    EnhancedListenerUpdater(List<EnhancedListenerType> listenerList, ExecutionDelegate<EventType, EnhancedListenerType> delegate, List<EventType> event) {
        this._fireUpdate(listenerList, delegate, event);
    }

    private void _fireUpdate(List<EnhancedListenerType> listenerList, final ExecutionDelegate<EventType, EnhancedListenerType> delegate, final List<EventType> eventList) {
        final ArrayList<EnhancedListener> _edtList = new ArrayList<EnhancedListener>();
        ArrayList<EnhancedListener> _nonEdtList = new ArrayList<EnhancedListener>();
        for (EnhancedListener listener : listenerList) {
            if (listener.mustRunInEDT()) {
                _edtList.add(listener);
                continue;
            }
            _nonEdtList.add(listener);
        }
        if (ThreadUtils.isInEDT()) {
            for (EnhancedListener listener : listenerList) {
                this._doFireEvent(delegate, eventList, listener);
            }
        } else {
            for (EnhancedListener listener : _nonEdtList) {
                this._doFireEvent(delegate, eventList, listener);
            }
            ThreadUtils.executeLaterInEDT(new Runnable(){

                public void run() {
                    for (EnhancedListener listener : _edtList) {
                        EnhancedListenerUpdater.this._doFireEvent(delegate, eventList, listener);
                    }
                }
            });
        }
    }

    private void _doFireEvent(ExecutionDelegate<EventType, EnhancedListenerType> delegate, List<EventType> eventList, EnhancedListenerType listener) {
        for (EventType event : eventList) {
            delegate.doFireEvent(listener, event);
        }
    }
}

