/*
 * Decompiled with CFR 0.152.
 */
package Task.Support.GUISupport;

import Task.Support.GUISupport.Colors;
import Task.Support.GUISupport.ImageUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.image.BufferedImage;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import org.swixml.contrib.gmap.Validate;

public class GUIUtils {
    private static Logger LOG = Logger.getLogger(GUIUtils.class.getName());

    private GUIUtils() {
    }

    public static char mnemonicToString(int mnemonic) throws IllegalArgumentException {
        char character = (char)(mnemonic + 32);
        if (character >= 'a' && character <= 'z') {
            return Character.toUpperCase(character);
        }
        throw new IllegalArgumentException("mnemonic is not between 'a' and 'z'");
    }

    public static String formatForLabel(String msg) {
        String formattedMsg = GUIUtils.encloseWithTag(GUIUtils.applyCenterTag(GUIUtils.applyFontColorTag(msg)), "html");
        return formattedMsg;
    }

    public static String makeLabelWithShortcut(String labelText, int keybAccel) {
        Validate.notEmpty(labelText, "label can not be empty or null");
        StringBuilder sb = new StringBuilder();
        sb.append(labelText);
        if (keybAccel != 0) {
            sb.append("<br><br>(<i>").append("Alt+").append(GUIUtils.mnemonicToString(keybAccel)).append("</i>)");
        }
        return GUIUtils.encloseWithTag(GUIUtils.applyFontColorTag(sb.toString()), "html");
    }

    public static String encloseWithTag(String msg, String tag) {
        StringBuilder sb = new StringBuilder();
        sb.append("<").append(tag).append(">").append(msg).append("</").append(tag).append(">");
        return sb.toString();
    }

    public static String encloseWithTag(String startTag, String msg, String endTag) {
        StringBuilder sb = new StringBuilder();
        sb.append(startTag).append(msg).append(endTag);
        return sb.toString();
    }

    public static String applyFontColorTag(String msg, Colors color) {
        StringBuilder sb = new StringBuilder();
        sb.append("<font color=").append(color.toHexString()).append(">").append(msg).append("</font>");
        return sb.toString();
    }

    public static String applyFontColorTag(String msg) {
        StringBuilder sb = new StringBuilder();
        sb.append("<font color=").append(Colors.DullBlue.toHexString()).append(">").append(msg).append("</font>");
        return sb.toString();
    }

    public static String applyCenterTag(String msg) {
        StringBuilder sb = new StringBuilder();
        sb.append("<center>").append(msg).append("</center>");
        return sb.toString();
    }

    public static String applyItalicTag(String msg) {
        StringBuilder sb = new StringBuilder();
        sb.append("<i>").append(msg).append("</i>");
        return sb.toString();
    }

    public static String applyBoldTag(String msg) {
        StringBuilder sb = new StringBuilder();
        sb.append("<b>").append(msg).append("</b>");
        return sb.toString();
    }

    public static String applyUnderlineTag(String msg) {
        StringBuilder sb = new StringBuilder();
        sb.append("<u>").append(msg).append("</u>");
        return sb.toString();
    }

    public static String getFormattedTooltip(String header, String description) {
        StringBuilder sb = new StringBuilder();
        return sb.toString();
    }

    public static void setUIDefaultFontProperty(String fontProp, Font font) {
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        defaults.put(fontProp, new FontUIResource(font));
    }

    public static void setUIDefaultColorProperty(String colorProp, Color color) {
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        defaults.put(colorProp, new ColorUIResource(color));
    }

    public static final void setSystemLookAndFeelBeforeUIStarted() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Problem setting native L&F at startup", e);
        }
    }

    public static final void setNimbusLookAndFeelBeforeUIStarted() {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Problem setting Mimbus L&F at startup", e);
        }
    }

    public static final void setSystemLookAndFeel(JFrame frame) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            SwingUtilities.updateComponentTreeUI(frame);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Problem setting native L&F after startup", e);
        }
    }

    public static void enableDynamicLayout() {
        try {
            Toolkit.getDefaultToolkit().setDynamicLayout(true);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Problem setting dynamic layout", e);
        }
    }

    public static final boolean isEmptyOrNull(String msg) {
        if (msg == null) {
            return true;
        }
        return msg.trim().equals("");
    }

    public static final void showErrorDialog(Component parentComponent, String msg) {
        if (GUIUtils.isEmptyOrNull(msg)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<html><font color=red>");
        sb.append(msg);
        sb.append("</font></html>");
        JOptionPane.showInternalMessageDialog(parentComponent, sb, "Exception", 2);
    }

    public static final void showErrorDialog(Component parentComponent, Throwable ex) {
        if (ex == null) {
            return;
        }
        String exClassName = ex.getClass().getName();
        String exToString = "";
        JOptionPane.showInternalMessageDialog(parentComponent, exToString, exClassName, 2);
    }

    public static final void showErrorDialog(Component parentComponent, String msg, Throwable ex) {
        String exToString;
        if (GUIUtils.isEmptyOrNull(msg)) {
            return;
        }
        if (ex == null) {
            String exClassName = "null";
            exToString = "";
        } else {
            String exClassName = ex.getClass().getName();
            exToString = "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<html><font color=red>");
        sb.append(msg);
        sb.append("</font><br></html>");
        sb.append(exToString);
        JOptionPane.showInternalMessageDialog(parentComponent, sb, exToString, 2);
    }

    public static final void centerOnScreen(JFrame frame) {
        frame.setLocationRelativeTo(null);
    }

    public static final void setMinimumWindowSize(JFrame frame, int w, int h) {
        frame.setMinimumSize(new Dimension(w, h));
    }

    public static final void setMinimumWindowSize(JFrame frame, Dimension d) {
        frame.setMinimumSize(d);
    }

    public static final void setAppIcon(JFrame frame, String image) {
        try {
            frame.setIconImage(ImageUtils.loadBufferedImage(image, false, 1.0f));
        }
        catch (ClassNotFoundException e) {
            LOG.log(Level.SEVERE, image + ".png - icon image for main frame not found in classpath", e);
        }
    }

    public static final void setAppIcon(JFrame frame, Image image) {
        frame.setIconImage(image);
    }

    public static final boolean isSystemTrayAvailable() {
        return SystemTray.isSupported();
    }

    public static final void addToSystemTray(TrayIcon icon) {
        try {
            SystemTray tray = SystemTray.getSystemTray();
            tray.add(icon);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "problem adding tray icon to the system tray", e);
        }
    }

    public static final void removeFromSystemTray(TrayIcon icon) {
        try {
            SystemTray tray = SystemTray.getSystemTray();
            tray.remove(icon);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "problem adding tray icon to the system tray", e);
        }
    }

    public static final TrayIcon getSystemTrayIcon(String iconName) throws UnsupportedOperationException {
        BufferedImage img = null;
        try {
            img = ImageUtils.loadBufferedImage(iconName, false, 1.0f);
        }
        catch (ClassNotFoundException e) {
            LOG.log(Level.SEVERE, "Could not find image file:" + iconName, e);
            img = GUIUtils.createFDImage();
        }
        return GUIUtils.getSystemTrayIcon(img);
    }

    public static final TrayIcon getSystemTrayIcon(BufferedImage img) throws UnsupportedOperationException {
        TrayIcon trayIcon = new TrayIcon(img);
        trayIcon.setImageAutoSize(true);
        return trayIcon;
    }

    protected static BufferedImage createFDImage() {
        BufferedImage bi = new BufferedImage(16, 16, 1);
        Graphics g = bi.getGraphics();
        g.setColor(Color.BLACK);
        g.fillRect(0, 0, 15, 15);
        g.setColor(Color.RED);
        g.fillOval(5, 3, 6, 6);
        g.dispose();
        return bi;
    }

    public static void launchExternalBrowser(String url) {
        if (Desktop.isDesktopSupported()) {
            Desktop desktop = Desktop.getDesktop();
            if (desktop.isSupported(Desktop.Action.BROWSE)) {
                try {
                    URI uri = new URI(url);
                    desktop.browse(uri);
                }
                catch (Exception e) {
                    LOG.log(Level.SEVERE, "encountered problem while trying to launch external browser", e);
                }
            } else {
                LOG.log(Level.SEVERE, "the underlying platform does not support the BROWSE Action on java.awt.Desktop, can't launch external browser for URL=" + url);
            }
        } else {
            LOG.log(Level.SEVERE, "the underlying platform does not support java.awt.Desktop API, can't launch external browser for URL=" + url);
        }
    }

    public static void putWindowBoundsToPersistence(Class myclass, Rectangle bounds) {
        try {
            Preferences prefs = Preferences.userNodeForPackage(myclass);
            Double width = bounds.getWidth();
            Double height = bounds.getHeight();
            Double x = bounds.getX();
            Double y = bounds.getY();
            prefs.putInt("height", height.intValue());
            prefs.putInt("width", width.intValue());
            prefs.putInt("x", x.intValue());
            prefs.putInt("y", y.intValue());
            prefs.flush();
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "problem occured while saving window locations to preferences", e);
        }
    }

    public static Rectangle getWindowBoundsFromPersistence(Class myclass) {
        try {
            Preferences prefs = Preferences.userNodeForPackage(myclass);
            int height = prefs.getInt("height", -1);
            int width = prefs.getInt("width", -1);
            int x = prefs.getInt("x", -1);
            int y = prefs.getInt("y", -1);
            if (x == -1 || y == -1) {
                return null;
            }
            return new Rectangle(x, y, width, height);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "problem occured while loading window locations from preferences", e);
            return null;
        }
    }
}

