/*
 * Decompiled with CFR 0.152.
 */
package org.swixml.contrib;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JWindow;
import javax.swing.border.EtchedBorder;
import org.swixml.LogAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Toaster
implements LogAware {
    private int toasterWidth = 300;
    private int toasterHeight = 80;
    private int step = 20;
    private int stepTime = 20;
    private long displayTime = 3000L;
    private int currentNumberOfToaster = 0;
    private int maxToaster = 0;
    private int maxToasterInSceen;
    private Font font;
    private Color borderColor;
    private Color toasterColor;
    private Color messageColor;
    int margin;
    boolean autoDismiss = true;
    boolean useAlwaysOnTop = true;
    final ReentrantLock _lock = new ReentrantLock();
    final Condition _waitForDismiss;

    public Toaster() {
        this.font = new Font("Arial", 1, 12);
        this.borderColor = new Color(245, 153, 15);
        this.toasterColor = Color.WHITE;
        this.messageColor = Color.BLACK;
        try {
            JWindow.class.getMethod("setAlwaysOnTop", Boolean.class);
        }
        catch (Exception e) {
            this.useAlwaysOnTop = false;
        }
        this._waitForDismiss = this._lock.newCondition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dismiss() {
        this._lock.lock();
        try {
            this._waitForDismiss.signal();
        }
        finally {
            this._lock.unlock();
        }
    }

    public void showToaster(Icon icon, String msg) {
        SingleToaster singleToaster = new SingleToaster();
        if (icon != null) {
            singleToaster.iconLabel.setIcon(icon);
        }
        singleToaster.message.setText(msg);
        this.animate(singleToaster);
    }

    public final void showToaster(String msg) {
        this.showToaster(null, msg);
    }

    protected <T extends JWindow> AnimationThread animate(T toaster) {
        AnimationThread anim = new AnimationThread(toaster);
        anim.start();
        return anim;
    }

    public boolean isAutoDismiss() {
        return this.autoDismiss;
    }

    public void setAutoDismiss(boolean autoDismiss) {
        this.autoDismiss = autoDismiss;
    }

    public Font getToasterMessageFont() {
        return this.font;
    }

    public Toaster setToasterMessageFont(Font f) {
        this.font = f;
        return this;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public Toaster setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
        return this;
    }

    public long getDisplayTime() {
        return this.displayTime;
    }

    public Toaster setDisplayTime(long displayTime) {
        this.displayTime = displayTime;
        return this;
    }

    public int getMargin() {
        return this.margin;
    }

    public Toaster setMargin(int margin) {
        this.margin = margin;
        return this;
    }

    public Color getMessageColor() {
        return this.messageColor;
    }

    public Toaster setMessageColor(Color messageColor) {
        this.messageColor = messageColor;
        return this;
    }

    public int getStep() {
        return this.step;
    }

    public Toaster setStep(int step) {
        this.step = step;
        return this;
    }

    public int getStepTime() {
        return this.stepTime;
    }

    public Toaster setStepTime(int stepTime) {
        this.stepTime = stepTime;
        return this;
    }

    public Color getToasterColor() {
        return this.toasterColor;
    }

    public Toaster setToasterColor(Color toasterColor) {
        this.toasterColor = toasterColor;
        return this;
    }

    public int getToasterHeight() {
        return this.toasterHeight;
    }

    public Toaster setToasterHeight(int toasterHeight) {
        this.toasterHeight = toasterHeight;
        return this;
    }

    public int getToasterWidth() {
        return this.toasterWidth;
    }

    public Toaster setToasterWidth(int toasterWidth) {
        this.toasterWidth = toasterWidth;
        return this;
    }

    public static void main(String[] args) {
        Toaster toasterManager = new Toaster().setStepTime(20).setStep(20);
        toasterManager.showToaster("JToaster Hello World!");
    }

    public class AnimationThread
    extends Thread {
        JWindow toaster;

        public AnimationThread(JWindow toaster2) {
            this.toaster = toaster2;
        }

        public void animateVertically(int posx, int fromY, int toY) throws InterruptedException {
            this.toaster.setLocation(posx, fromY);
            if (toY < fromY) {
                for (int i = fromY; i > toY; i -= Toaster.this.step) {
                    this.toaster.setLocation(posx, i);
                    Thread.sleep(Toaster.this.stepTime);
                }
            } else {
                for (int i = fromY; i < toY; i += Toaster.this.step) {
                    this.toaster.setLocation(posx, i);
                    Thread.sleep(Toaster.this.stepTime);
                }
            }
            this.toaster.setLocation(posx, toY);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                int stopYPosition;
                int startYPosition;
                boolean animateFromBottom = true;
                GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                Rectangle screenRect = ge.getMaximumWindowBounds();
                int screenHeight = screenRect.height;
                if (screenRect.y > 0) {
                    animateFromBottom = false;
                }
                Toaster.this.maxToasterInSceen = screenHeight / Toaster.this.toasterHeight;
                int posx = screenRect.width - Toaster.this.toasterWidth - 1;
                this.toaster.setLocation(posx, screenHeight);
                this.toaster.setVisible(true);
                if (Toaster.this.useAlwaysOnTop) {
                    this.toaster.setAlwaysOnTop(true);
                }
                if (animateFromBottom) {
                    startYPosition = screenHeight;
                    stopYPosition = startYPosition - Toaster.this.toasterHeight - 1;
                    if (Toaster.this.currentNumberOfToaster > 0) {
                        stopYPosition -= Toaster.this.maxToaster % Toaster.this.maxToasterInSceen * Toaster.this.toasterHeight;
                    } else {
                        Toaster.this.maxToaster = 0;
                    }
                } else {
                    startYPosition = screenRect.y - Toaster.this.toasterHeight;
                    stopYPosition = screenRect.y;
                    if (Toaster.this.currentNumberOfToaster > 0) {
                        stopYPosition += Toaster.this.maxToaster % Toaster.this.maxToasterInSceen * Toaster.this.toasterHeight;
                    } else {
                        Toaster.this.maxToaster = 0;
                    }
                }
                Toaster.this.currentNumberOfToaster++;
                Toaster.this.maxToaster++;
                this.animateVertically(posx, startYPosition, stopYPosition);
                if (Toaster.this.isAutoDismiss()) {
                    if (Toaster.this.getDisplayTime() > 0L) {
                        Thread.sleep(Toaster.this.displayTime);
                    }
                } else {
                    Toaster.this._lock.lock();
                    try {
                        if (Toaster.this.getDisplayTime() > 0L) {
                            if (!Toaster.this._waitForDismiss.await(Toaster.this.getDisplayTime(), TimeUnit.MILLISECONDS)) {
                                LogAware.logger.warning("waitForDismiss timeout.....");
                            }
                        } else {
                            Toaster.this._waitForDismiss.await();
                        }
                    }
                    finally {
                        Toaster.this._lock.unlock();
                    }
                }
                this.animateVertically(posx, stopYPosition, startYPosition);
                this.toaster.setVisible(false);
                this.toaster.dispose();
                Toaster.this.currentNumberOfToaster--;
            }
            catch (Exception e) {
                LogAware.logger.log(Level.SEVERE, "error rendering toaster", e);
            }
        }
    }

    class SingleToaster
    extends JWindow {
        private static final long serialVersionUID = 1L;
        private JLabel iconLabel = new JLabel();
        private JTextArea message = new JTextArea();

        public SingleToaster() {
            this.initComponents();
        }

        private void initComponents() {
            this.setSize(Toaster.this.toasterWidth, Toaster.this.toasterHeight);
            this.message.setFont(Toaster.this.getToasterMessageFont());
            JPanel externalPanel = new JPanel(new BorderLayout(1, 1));
            JPanel innerPanel = new JPanel(new BorderLayout(Toaster.this.getMargin(), Toaster.this.getMargin()));
            externalPanel.setBackground(Toaster.this.getBorderColor());
            innerPanel.setBackground(Toaster.this.getToasterColor());
            this.message.setBackground(Toaster.this.getToasterColor());
            this.message.setMargin(new Insets(2, 2, 2, 2));
            this.message.setLineWrap(true);
            this.message.setWrapStyleWord(true);
            EtchedBorder etchedBorder = (EtchedBorder)BorderFactory.createEtchedBorder();
            externalPanel.setBorder(etchedBorder);
            externalPanel.add(innerPanel);
            this.message.setForeground(Toaster.this.getMessageColor());
            innerPanel.add((Component)this.iconLabel, "West");
            innerPanel.add((Component)this.message, "Center");
            this.getContentPane().add(externalPanel);
        }
    }
}

