/*
 * Decompiled with CFR 0.152.
 */
package org.swixml.contrib.gmap;

import java.io.Serializable;
import java.util.regex.Pattern;

public class MapMarker
implements Serializable {
    static final long serialVersionUID = 5805831996822361347L;
    private char _alpha = (char)49;
    private MarkerColor _color = null;
    private double _lat = -1.0;
    private double _lon = -1.0;

    public MapMarker(double lat, double lon, MarkerColor color, char alpha) {
        this._lat = lat;
        this._lon = lon;
        this._color = color;
        this._alpha = alpha;
        StringBuffer buf = new StringBuffer();
        buf.append(alpha);
        if (!Pattern.matches("[a-zA-Z]", buf)) {
            throw new IllegalArgumentException("marker alpha is not a char between a-z");
        }
        if (color == null) {
            throw new IllegalArgumentException("marker color can not be null");
        }
    }

    public MapMarker(double lat, double lon) {
        this._lat = lat;
        this._lon = lon;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._lat).append(",").append(this._lon);
        if (this._color != null && this._alpha != '1') {
            sb.append(",").append(this._color.toString()).append(this._alpha);
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum MarkerColor {
        red,
        green,
        blue;

    }
}

