/*
 * Decompiled with CFR 0.152.
 */
package org.purl.sword.base;

import java.util.Properties;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import org.apache.log4j.Logger;
import org.purl.sword.atom.Entry;
import org.purl.sword.base.SwordNoOp;
import org.purl.sword.base.SwordPackaging;
import org.purl.sword.base.SwordTreatment;
import org.purl.sword.base.SwordUserAgent;
import org.purl.sword.base.SwordValidationInfo;
import org.purl.sword.base.SwordValidationInfoType;
import org.purl.sword.base.SwordVerboseDescription;
import org.purl.sword.base.UnmarshallException;
import org.purl.sword.base.XmlName;

public class SWORDEntry
extends Entry {
    protected SwordNoOp swordNoOp;
    protected SwordVerboseDescription swordVerboseDescription;
    protected SwordTreatment swordTreatment;
    protected SwordUserAgent swordUserAgent;
    private SwordPackaging swordPackaging;
    private static Logger log = Logger.getLogger(SWORDEntry.class);

    public SWORDEntry(String namespace, String element, String namespaceUri) {
        super(namespace, element, namespaceUri);
    }

    public SWORDEntry() {
    }

    public SWORDEntry(XmlName name) {
        super(name);
    }

    @Override
    protected void initialise() {
        super.initialise();
        this.swordNoOp = null;
        this.swordPackaging = null;
        this.swordVerboseDescription = null;
        this.swordTreatment = null;
        this.swordUserAgent = null;
    }

    public boolean isNoOp() {
        if (this.swordNoOp == null) {
            return false;
        }
        return this.swordNoOp.getContent();
    }

    public void setNoOp(boolean noOp) {
        this.swordNoOp = new SwordNoOp(noOp);
    }

    public boolean isNoOpSet() {
        if (this.swordNoOp == null) {
            return false;
        }
        return this.swordNoOp.isSet();
    }

    public String getVerboseDescription() {
        if (this.swordVerboseDescription == null) {
            return null;
        }
        return this.swordVerboseDescription.getContent();
    }

    public void setVerboseDescription(String verboseDescription) {
        this.swordVerboseDescription = new SwordVerboseDescription(verboseDescription);
    }

    public String getTreatment() {
        if (this.swordTreatment == null) {
            return null;
        }
        return this.swordTreatment.getContent();
    }

    public void setTreatment(String treatment) {
        this.swordTreatment = new SwordTreatment(treatment);
    }

    public String getUserAgent() {
        if (this.swordUserAgent == null) {
            return null;
        }
        return this.swordUserAgent.getContent();
    }

    public void setUserAgent(String userAgent) {
        this.swordUserAgent = new SwordUserAgent(userAgent);
    }

    public String getPackaging() {
        if (this.swordPackaging == null) {
            return null;
        }
        return this.swordPackaging.getContent();
    }

    public void setPackaging(String packaging) {
        this.swordPackaging = new SwordPackaging(packaging);
    }

    @Override
    public Element marshall() {
        Element entry = super.marshall();
        return entry;
    }

    @Override
    protected void marshallElements(Element entry) {
        super.marshallElements(entry);
        if (this.swordTreatment != null) {
            entry.appendChild((Node)this.swordTreatment.marshall());
        }
        if (this.swordVerboseDescription != null) {
            entry.appendChild((Node)this.swordVerboseDescription.marshall());
        }
        if (this.swordNoOp != null) {
            entry.appendChild((Node)this.swordNoOp.marshall());
        }
        if (this.swordUserAgent != null) {
            entry.appendChild((Node)this.swordUserAgent.marshall());
        }
        if (this.swordPackaging != null) {
            entry.appendChild((Node)this.swordPackaging.marshall());
        }
    }

    public SwordValidationInfo unmarshallWithValidation(Element entry, Properties validationProperties) throws UnmarshallException {
        SwordValidationInfo result = super.unmarshallWithoutValidate(entry, validationProperties);
        this.processUnexpectedAttributes(entry, result);
        Elements elements = entry.getChildElements();
        Element element = null;
        int length = elements.size();
        for (int i = 0; i < length; ++i) {
            XmlName name;
            SwordValidationInfo info;
            element = elements.get(i);
            if (this.isInstanceOf(element, SwordTreatment.elementName())) {
                if (this.swordTreatment == null) {
                    this.swordTreatment = new SwordTreatment();
                    result.addUnmarshallElementInfo(this.swordTreatment.unmarshall(element, validationProperties));
                    continue;
                }
                if (validationProperties == null) continue;
                info = new SwordValidationInfo(SwordTreatment.elementName(), "This element has already been included earlier in this document. This element is ignored.", SwordValidationInfoType.WARNING);
                info.setContentDescription(element.getValue());
                result.addUnmarshallElementInfo(info);
                continue;
            }
            if (this.isInstanceOf(element, SwordNoOp.elementName())) {
                if (this.swordNoOp == null) {
                    this.swordNoOp = new SwordNoOp();
                    result.addUnmarshallElementInfo(this.swordNoOp.unmarshall(element, validationProperties));
                    continue;
                }
                if (validationProperties == null) continue;
                info = new SwordValidationInfo(SwordNoOp.elementName(), "This element has already been included earlier in this document. This element is ignored.", SwordValidationInfoType.WARNING);
                info.setContentDescription(element.getValue());
                result.addUnmarshallElementInfo(info);
                continue;
            }
            if (this.isInstanceOf(element, SwordVerboseDescription.elementName())) {
                if (this.swordVerboseDescription == null) {
                    this.swordVerboseDescription = new SwordVerboseDescription();
                    result.addUnmarshallElementInfo(this.swordVerboseDescription.unmarshall(element, validationProperties));
                    continue;
                }
                if (validationProperties == null) continue;
                info = new SwordValidationInfo(SwordVerboseDescription.elementName(), "This element has already been included earlier in this document. This element is ignored.", SwordValidationInfoType.WARNING);
                info.setContentDescription(element.getValue());
                result.addUnmarshallElementInfo(info);
                continue;
            }
            if (this.isInstanceOf(element, SwordUserAgent.elementName())) {
                if (this.swordUserAgent == null) {
                    this.swordUserAgent = new SwordUserAgent();
                    result.addUnmarshallElementInfo(this.swordUserAgent.unmarshall(element, validationProperties));
                    continue;
                }
                if (validationProperties == null) continue;
                info = new SwordValidationInfo(SwordUserAgent.elementName(), "This element has already been included earlier in this document. This element is ignored.", SwordValidationInfoType.WARNING);
                info.setContentDescription(element.getValue());
                result.addUnmarshallElementInfo(info);
                continue;
            }
            if (this.isInstanceOf(element, SwordPackaging.elementName())) {
                if (this.swordPackaging == null) {
                    this.swordPackaging = new SwordPackaging();
                    result.addUnmarshallElementInfo(this.swordPackaging.unmarshall(element, validationProperties));
                    continue;
                }
                if (validationProperties == null) continue;
                info = new SwordValidationInfo(SwordPackaging.elementName(), "This element has already been included earlier in this document. This element is ignored.", SwordValidationInfoType.WARNING);
                info.setContentDescription(element.getValue());
                result.addUnmarshallElementInfo(info);
                continue;
            }
            if (validationProperties == null || this.isElementChecked(name = new XmlName(element))) continue;
            SwordValidationInfo info2 = new SwordValidationInfo(name, "This element is present, but it is not used as part of the SWORD profile", SwordValidationInfoType.INFO);
            info2.setContentDescription(element.getValue());
            result.addUnmarshallElementInfo(info2);
        }
        return result;
    }

    @Override
    public SwordValidationInfo unmarshall(Element entry, Properties validationProperties) throws UnmarshallException {
        SwordValidationInfo result = this.unmarshallWithValidation(entry, validationProperties);
        if (validationProperties != null) {
            result = this.validate(result, validationProperties);
        }
        return result;
    }

    @Override
    protected boolean isElementChecked(XmlName elementName) {
        if (elementName == null) {
            return false;
        }
        return elementName.equals(SwordNoOp.elementName()) | elementName.equals(SwordUserAgent.elementName()) | elementName.equals(SwordTreatment.elementName()) | elementName.equals(SwordVerboseDescription.elementName()) | elementName.equals(SwordPackaging.elementName()) | super.isElementChecked(elementName);
    }

    @Override
    public SwordValidationInfo validate(Properties validationContext) {
        return this.validate(null, validationContext);
    }

    @Override
    protected SwordValidationInfo validate(SwordValidationInfo info, Properties validationContext) {
        boolean validateAll = info == null;
        SwordValidationInfo swordEntry = super.validate(info, validationContext);
        if (this.swordUserAgent == null) {
            String agent = validationContext.getProperty("User-Agent");
            if (agent != null) {
                swordEntry.addValidationInfo(new SwordValidationInfo(SwordUserAgent.elementName(), "This element is not present, but it SHOULD be included. Clients SHOULD provide a User-Agent request-header (as described in [HTTP1.1] section 14.43). If provided, servers SHOULD store the value in the sword:userAgent element.", SwordValidationInfoType.WARNING));
            }
        } else if (this.swordUserAgent != null && validateAll) {
            info.addValidationInfo(this.swordUserAgent.validate(validationContext));
        }
        if (this.swordTreatment == null) {
            swordEntry.addValidationInfo(new SwordValidationInfo(SwordTreatment.elementName(), "This element is not present, but at least one MUST be included. MUST be present and contain either a human-readable statement describing treatment the deposited resource has received or a URI that dereferences to such a description.", SwordValidationInfoType.ERROR));
        } else if (this.swordTreatment != null && validateAll) {
            info.addValidationInfo(this.swordTreatment.validate(validationContext));
        }
        if (this.swordVerboseDescription == null) {
            String verbose = validationContext.getProperty("X-Verbose");
            if (verbose != null) {
                swordEntry.addValidationInfo(new SwordValidationInfo(SwordVerboseDescription.elementName(), "This element is not present, but it SHOULD be included. If the client made the POST request with an X-Verbose:true header, the server SHOULD supply a verbose description of the deposit process.", SwordValidationInfoType.WARNING));
            }
        } else if (this.swordVerboseDescription != null && validateAll) {
            info.addValidationInfo(this.swordVerboseDescription.validate(validationContext));
        }
        if (this.swordNoOp == null) {
            String noOp = validationContext.getProperty("X-No-Op");
            if (noOp != null) {
                swordEntry.addValidationInfo(new SwordValidationInfo(SwordNoOp.elementName(), "This element is not present, but it SHOULD be included. If the client made the POST request with an X-No-Op:true header, the server SHOULD reflect this by including a sword:noOp element with a value of 'true' in the response. See Part A Section 3.1. Servers MAY use a value of 'false' to indicate that the deposit proceeded but MUST NOT use this element to signify an error.", SwordValidationInfoType.WARNING));
            }
        } else if (this.swordNoOp != null && validateAll) {
            info.addValidationInfo(this.swordNoOp.validate(validationContext));
        }
        if (this.swordPackaging == null) {
            swordEntry.addValidationInfo(new SwordValidationInfo(SwordPackaging.elementName(), "This element is not present, but it SHOULD be included. If the POST request results in the creation of packaged resource, the server MAY use this element to declare the packaging type. If used it SHOULD take a value from [SWORD-TYPES].", SwordValidationInfoType.INFO));
        } else if (this.swordPackaging != null && validateAll) {
            info.addValidationInfo(this.swordPackaging.validate(validationContext));
        }
        return swordEntry;
    }

    @Override
    public void unmarshall(Element entry) throws UnmarshallException {
        this.unmarshall(entry, null);
    }
}

