/*
 * Decompiled with CFR 0.152.
 */
package org.purl.sword.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.jdesktop.swingworker.SwingWorker;
import org.purl.sword.base.DepositResponse;
import org.purl.sword.base.SWORDErrorDocument;
import org.purl.sword.base.SWORDException;
import org.purl.sword.base.ServiceDocument;
import org.purl.sword.base.SwordValidationInfo;
import org.purl.sword.base.SwordValidationInfoType;
import org.purl.sword.client.Client;
import org.purl.sword.client.ClientOptions;
import org.purl.sword.client.ClientType;
import org.purl.sword.client.DebugOutputStream;
import org.purl.sword.client.MessageOutputPanel;
import org.purl.sword.client.PostDestination;
import org.purl.sword.client.PostDialog;
import org.purl.sword.client.PostMessage;
import org.purl.sword.client.PropertiesDialog;
import org.purl.sword.client.SWORDClientException;
import org.purl.sword.client.ServiceDialog;
import org.purl.sword.client.ServicePanel;
import org.purl.sword.client.ServiceSelectedListener;
import org.purl.sword.client.Status;

public class GuiClient
extends JFrame
implements ClientType,
ServiceSelectedListener {
    private static final String PROPERTY_FILE = "SwordClient.properties";
    private static final String ON_BEHALF_OF = "onBehalfOf";
    private ServiceDialog serviceDialog;
    private PostDialog postDialog;
    private MainPanel mainPanel = null;
    private PostAction postAction = null;
    JCheckBoxMenuItem debug = null;
    Action serviceAction = null;
    Properties props = null;
    private Client swordclient;
    private static Logger log = Logger.getLogger(GuiClient.class);
    private File propFile;

    public GuiClient() {
        super("SWORD Demonstration Client");
    }

    /*
     * Loose catch block
     */
    private void loadProperties() {
        log.debug((Object)"Loading props");
        FileInputStream stream = null;
        try {
            this.props = new Properties();
            URL propUrl = Thread.currentThread().getContextClassLoader().getResource(PROPERTY_FILE);
            log.debug((Object)("The property file url is: " + propUrl));
            if (propUrl == null) {
                throw new IOException("Could not find properties file.");
            }
            if ("file".equals(propUrl.getProtocol())) {
                this.propFile = new File(propUrl.toURI());
            } else {
                this.propFile = new File(PROPERTY_FILE);
                FileUtils.copyURLToFile((URL)propUrl, (File)this.propFile);
            }
            stream = new FileInputStream(this.propFile);
            this.props.load(stream);
            IOUtils.closeQuietly((InputStream)stream);
        }
        catch (IOException ioe) {
            log.error((Object)"Unable to load property file");
            JOptionPane.showMessageDialog(this, "Unable to load properties file " + ioe.getMessage(), "Properties", 0);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Most unexpectedly, a file URL is not a URI.", e);
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            IOUtils.closeQuietly(stream);
        }
        log.info((Object)"Loaded props");
    }

    private void processProperties() {
        if (this.props != null) {
            String value = this.props.getProperty("proxyHost");
            log.debug((Object)("the proxy host is set to: " + value));
            if (value != null && value.trim().length() > 0) {
                try {
                    URL url = new URL(value);
                    int port = url.getPort();
                    if (port == -1) {
                        port = 80;
                    }
                    log.debug((Object)("host is : " + url.getHost()));
                    this.swordclient.setProxy(url.getHost(), port);
                }
                catch (MalformedURLException mue) {
                    JOptionPane.showMessageDialog(this, "Unable to set Proxy Host " + mue.getMessage(), "Properties", 0);
                }
            } else {
                this.swordclient.clearProxy();
            }
        }
    }

    @Override
    public void run(ClientOptions options) {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                GuiClient.this.saveProperties();
                log.debug((Object)"Exiting.");
                System.exit(0);
            }
        });
        JMenuBar menubar = new JMenuBar();
        QuitAction quitAction = new QuitAction();
        this.serviceAction = new AddServiceAction();
        this.postAction = new PostAction();
        JMenu fileMenu = new JMenu("File");
        fileMenu.add(this.serviceAction);
        fileMenu.add(this.postAction);
        fileMenu.addSeparator();
        fileMenu.add(quitAction);
        menubar.add(fileMenu);
        JMenu optionsMenu = new JMenu("Options");
        this.debug = new JCheckBoxMenuItem(new DebugAction());
        optionsMenu.add(this.debug);
        optionsMenu.add(new EditPropertiesAction());
        optionsMenu.add(new ValidationInfoAction());
        menubar.add(optionsMenu);
        JMenu actionMenu = new JMenu("Help");
        actionMenu.add(new HelpAction());
        actionMenu.add(new AboutAction());
        menubar.add(actionMenu);
        this.setJMenuBar(menubar);
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        this.add((Component)toolbar, "First");
        toolbar.add(this.serviceAction);
        toolbar.add(this.postAction);
        Container c = this.getContentPane();
        log.debug((Object)"Creating main panel ...");
        this.mainPanel = new MainPanel(options.isNoCapture());
        c.add(this.mainPanel);
        log.debug((Object)"Initialising client ...");
        this.swordclient = new Client();
        log.debug((Object)"Loading props ...");
        this.loadProperties();
        this.processProperties();
        this.pack();
        this.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void saveProperties() {
        block7: {
            block6: {
                if (this.props == null || this.propFile == null) break block6;
                FileOutputStream out = null;
                try {
                    out = new FileOutputStream(this.propFile);
                    log.debug((Object)("saving to... " + this.propFile));
                    this.props.store(out, null);
                }
                catch (FileNotFoundException e) {
                    log.error((Object)("Unable to store the file: " + e.getMessage()), (Throwable)e);
                    IOUtils.closeQuietly((OutputStream)out);
                }
                catch (IOException e2) {
                    log.error((Object)("Error storing the file: " + e2.getMessage()), (Throwable)e2);
                    {
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(out);
                            throw throwable;
                        }
                    }
                    IOUtils.closeQuietly((OutputStream)out);
                }
                IOUtils.closeQuietly((OutputStream)out);
                break block7;
            }
            log.warn((Object)("Either props: " + this.props + " or prop file: " + this.propFile + " were null - not saving."));
        }
    }

    private void enableActions(boolean enabled) {
        this.serviceAction.setEnabled(enabled);
        this.postAction.setEnabled(enabled);
    }

    private void initialiseServer(String location, String username, String password) throws MalformedURLException {
        URL url = new URL(location);
        int port = url.getPort();
        if (port == -1) {
            port = 80;
        }
        this.swordclient.setServer(url.getHost(), port);
        if (username != null && username.length() > 0 && password != null && password.length() > 0) {
            this.swordclient.setCredentials(username, password);
        } else {
            this.swordclient.clearCredentials();
        }
        this.swordclient.setUserAgent("CASIS Test Client");
    }

    @Override
    public void selected(String value) {
        this.postAction.setCollection(value);
    }

    protected class MainPanel
    extends JPanel {
        private MessageOutputPanel messages;
        private ServicePanel services;
        private JTabbedPane tabbedMessages;
        private MessageOutputPanel debugPanel;
        private JLabel statusLabel;

        public MainPanel(boolean noCaptureOutput) {
            super(new BorderLayout());
            this.messages = null;
            this.services = null;
            this.tabbedMessages = null;
            this.debugPanel = null;
            this.statusLabel = null;
            log.debug((Object)"Constructing MainPanel ...");
            this.services = new ServicePanel();
            this.services.setServiceSelectedListener(GuiClient.this);
            this.messages = new MessageOutputPanel();
            this.debugPanel = new MessageOutputPanel();
            DebugOutputStream output = new DebugOutputStream(this.debugPanel);
            if (!noCaptureOutput) {
                log.debug((Object)"Capturing output ...");
                System.setErr(new PrintStream(output));
                System.setOut(new PrintStream(output));
                PropertyConfigurator.configure((URL)this.getClass().getClassLoader().getResource("log4j.properties"));
            }
            this.tabbedMessages = new JTabbedPane();
            this.tabbedMessages.addTab("Messages", this.messages);
            JSplitPane splitPane = new JSplitPane(0, this.services, this.tabbedMessages);
            splitPane.setOneTouchExpandable(true);
            splitPane.setResizeWeight(0.5);
            splitPane.setDividerLocation(300);
            this.statusLabel = new JLabel(" ");
            this.add((Component)splitPane, "Center");
            this.add((Component)this.statusLabel, "South");
        }

        public void showDebugTab(boolean enabled) {
            if (enabled) {
                if (this.tabbedMessages.getTabCount() == 1) {
                    this.tabbedMessages.addTab("Debug", this.debugPanel);
                    this.tabbedMessages.setSelectedComponent(this.debugPanel);
                }
            } else if (this.tabbedMessages.getTabCount() == 2) {
                this.tabbedMessages.remove(this.debugPanel);
            }
        }

        public void addMessage(String message) {
            this.messages.addMessage(message);
        }

        public void processServiceDocument(String url, ServiceDocument service) {
            this.services.processServiceDocument(url, service);
        }

        public void processDespositResponse(String url, DepositResponse response) {
            this.services.processDepositResponse(url, response);
        }

        public String[] getCollectionLocations() {
            return this.services.getCollectionLocations();
        }

        public void setStatus(String statusMessage) {
            this.statusLabel.setText(statusMessage);
        }
    }

    protected class HelpAction
    extends AbstractAction {
        public HelpAction() {
            super("Help");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                File helpDir = File.createTempFile("swordHelp", null);
                if (!helpDir.delete()) {
                    throw new IOException("Couldn't create tmp dir: " + helpDir);
                }
                if (!helpDir.mkdirs()) {
                    throw new IOException("Couldn't create tmp dir: " + helpDir);
                }
                this.extractHelp(helpDir);
                String osname = System.getProperty("os.name");
                log.info((Object)("osname is: " + osname));
                String runCmd = "";
                if ("Mac OS X".equals(osname)) {
                    runCmd = "open";
                } else if ("Windows XP".equals(osname)) {
                    runCmd = "rundll32 url.dll,FileProtocolHandler";
                } else if ("Linux".equals(osname)) {
                    runCmd = "firefox";
                } else {
                    log.error((Object)(osname + " not supported."));
                }
                String helpFile = helpDir.getCanonicalPath() + File.separator + "index.html";
                Runtime.getRuntime().exec(runCmd + " " + helpFile);
            }
            catch (IOException ioe) {
                log.error((Object)"Error accessing help files");
                ioe.printStackTrace();
            }
            catch (URISyntaxException e) {
                log.error((Object)"Error accessing help files");
                e.printStackTrace();
            }
        }

        private void extractHelp(File helpDir) throws URISyntaxException, IOException {
            ClassLoader cl = this.getClass().getClassLoader();
            URL help = cl.getResource("help");
            if ("file".equals(help.getProtocol())) {
                File from = new File(help.toURI());
                FileUtils.copyDirectory((File)from, (File)helpDir);
            } else if ("jar".equals(help.getProtocol())) {
                log.debug((Object)("Help url: " + help));
                String jarLoc = help.toString().substring(9, help.toString().lastIndexOf("!"));
                File f = new File(jarLoc);
                if (!f.exists()) {
                    log.error((Object)"Cannot display help - can't find help files to make a local temp copy");
                }
                JarFile jarFile = new JarFile(jarLoc);
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry je = entries.nextElement();
                    if (!je.getName().startsWith("help/")) continue;
                    log.debug((Object)(je.getName() + " | Directory? " + je.isDirectory()));
                    String filename = je.getName().substring(5).replaceAll("/", File.separator);
                    File destination = new File(helpDir, filename);
                    File directory = je.isDirectory() ? destination : destination.getParentFile();
                    log.debug((Object)("Creating " + directory + " and copying resource to " + destination));
                    if (!directory.exists() && !directory.mkdirs()) {
                        throw new IOException("Problem creating temp help directory, couldn't create: " + directory);
                    }
                    if (je.isDirectory()) continue;
                    FileUtils.copyURLToFile((URL)cl.getResource(je.getName()), (File)destination);
                }
            } else {
                throw new RuntimeException("Don't know how to unpack help files from " + help);
            }
        }
    }

    protected class AboutAction
    extends AbstractAction {
        public AboutAction() {
            super("About");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            JOptionPane.showMessageDialog(null, "Demonstration client for SWORD Project - supporting SWORD Profile 1.3\nCopyright 2007-2009 CASIS, University of Wales Aberystwyth\n\nVersion 1.1", "About", 1);
        }
    }

    protected class PostAction
    extends AbstractAction {
        private String collection;

        public PostAction() {
            super("Post");
            this.collection = null;
            ClassLoader loader = this.getClass().getClassLoader();
            URL url = loader.getResource("images/PostButton.gif");
            ImageIcon icon = new ImageIcon(url);
            this.putValue("SmallIcon", icon);
            this.putValue("ShortDescription", "Post file");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            this.initialisePostDialog();
            int result = GuiClient.this.postDialog.show();
            if (result == 0) {
                SwingWorker<String, String> worker = new SwingWorker<String, String>(){

                    protected String doInBackground() throws Exception {
                        PostDestination[] destinations;
                        GuiClient.this.enableActions(false);
                        GuiClient.this.setCursor(new Cursor(3));
                        for (PostDestination destination : destinations = GuiClient.this.postDialog.getDestinations()) {
                            try {
                                String outputMessage;
                                String location = destination.getUrl();
                                String username = destination.getUsername();
                                String password = destination.getPassword();
                                GuiClient.this.initialiseServer(location, username, password);
                                if (username != null && username.length() > 0 && password != null && password.length() > 0) {
                                    this.publish(new String[]{"Setting the username/password: " + username + " " + password});
                                    GuiClient.this.swordclient.setCredentials(username, password);
                                } else {
                                    GuiClient.this.swordclient.clearCredentials();
                                }
                                PostMessage message = new PostMessage();
                                message.setDestination(location);
                                message.setFilepath(GuiClient.this.postDialog.getFile());
                                message.setFiletype(GuiClient.this.postDialog.getFileType());
                                message.setFormatNamespace(GuiClient.this.postDialog.getFormatNamespace());
                                message.setUseMD5(GuiClient.this.postDialog.useMd5());
                                message.setVerbose(GuiClient.this.postDialog.useVerbose());
                                message.setOnBehalfOf(destination.getOnBehalfOf());
                                message.setNoOp(GuiClient.this.postDialog.useNoOp());
                                message.setChecksumError(GuiClient.this.postDialog.corruptMD5());
                                message.setCorruptRequest(GuiClient.this.postDialog.corruptRequest());
                                message.setUserAgent("CASIS Test Client");
                                this.publish(new String[]{"Posting file to: " + location});
                                DepositResponse document = GuiClient.this.swordclient.postFile(message);
                                Status status = GuiClient.this.swordclient.getStatus();
                                this.publish(new String[]{"The status is: " + status});
                                SwordValidationInfo info = GuiClient.this.swordclient.getLastUnmarshallInfo();
                                if (info != null && info.getType() == SwordValidationInfoType.VALID) {
                                    this.publish(new String[]{"The document was valid"});
                                } else if (info != null) {
                                    this.publish(new String[]{"This document did not validate."});
                                    StringBuffer buffer = new StringBuffer();
                                    info.createString(info, buffer, " ");
                                    this.publish(new String[]{buffer.toString()});
                                }
                                if (status.getCode() == 201 || status.getCode() == 202) {
                                    GuiClient.this.mainPanel.processDespositResponse(location, document);
                                    GuiClient.this.mainPanel.addMessage(document.marshall());
                                    this.publish(new String[]{"Data received for location: " + location});
                                    continue;
                                }
                                this.publish(new String[]{"Unable to post file to: " + location});
                                GuiClient.this.mainPanel.addMessage(document.marshall());
                                try {
                                    SWORDErrorDocument errorDoc = document.getErrorDocument();
                                    outputMessage = "Unable to post file to " + location + ".\r\nStatus is: " + status.toString() + ".\r\nThe Error URI is: " + errorDoc.getErrorURI() + "\r\nSummary is: " + errorDoc.getSummary();
                                }
                                catch (SWORDException se) {
                                    outputMessage = se.getMessage();
                                }
                                JOptionPane.showMessageDialog(GuiClient.this, outputMessage, "Post File", 2);
                            }
                            catch (MalformedURLException ex) {
                                this.publish(new String[]{"Unable to access resource. Error with URL."});
                                JOptionPane.showMessageDialog(GuiClient.this, "There is an error with the URL. " + ex.getMessage(), "Service Access Error", 0);
                            }
                            catch (SWORDClientException sce) {
                                this.publish(new String[]{"Unable to access resource."});
                                JOptionPane.showMessageDialog(GuiClient.this, "There was an error accessing the resource. " + sce.getMessage(), "Service Access Error", 0);
                            }
                        }
                        return "Finished";
                    }

                    protected void done() {
                        GuiClient.this.enableActions(true);
                        GuiClient.this.setCursor(new Cursor(0));
                    }

                    protected void process(List<String> chunks) {
                        for (String row : chunks) {
                            String message = "status: " + row;
                            GuiClient.this.mainPanel.addMessage(message);
                            GuiClient.this.mainPanel.setStatus(message);
                        }
                    }
                };
                worker.execute();
            }
        }

        public void setCollection(String collection) {
            this.collection = collection;
        }

        protected void initialisePostDialog() {
            String[] users;
            if (GuiClient.this.postDialog == null) {
                GuiClient.this.postDialog = new PostDialog(GuiClient.this);
            }
            String[] locations = GuiClient.this.mainPanel.getCollectionLocations();
            GuiClient.this.postDialog.addDepositUrls(locations);
            String value = GuiClient.this.props.getProperty("depositurls");
            if (value != null) {
                String[] services = value.split(",");
                GuiClient.this.postDialog.addDepositUrls(services);
            }
            if ((value = GuiClient.this.props.getProperty("users")) != null) {
                users = value.split(",");
                GuiClient.this.postDialog.addUserIds(users);
            }
            if ((value = GuiClient.this.props.getProperty("formatNamespaceList")) != null) {
                String[] namespaces = value.split(",");
                GuiClient.this.postDialog.addFormatNamespaces(namespaces);
            }
            if ((value = GuiClient.this.props.getProperty(GuiClient.ON_BEHALF_OF)) != null) {
                users = value.split(",");
                GuiClient.this.postDialog.addOnBehalfOf(users);
            }
            if ((value = GuiClient.this.props.getProperty("files")) != null) {
                String[] files = value.split(",");
                GuiClient.this.postDialog.addFiles(files);
            }
            if ((value = GuiClient.this.props.getProperty("fileTypes")) != null) {
                String[] fileTypes = value.split(",");
                GuiClient.this.postDialog.addFileTypes(fileTypes);
            }
            if (this.collection != null) {
                log.debug((Object)("setting collection: " + this.collection));
                GuiClient.this.postDialog.setDepositLocation(this.collection);
            }
        }
    }

    protected class DebugAction
    extends AbstractAction {
        public DebugAction() {
            super("Show Debug Panel");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            boolean setDebug = GuiClient.this.debug.isSelected();
            GuiClient.this.mainPanel.showDebugTab(setDebug);
        }
    }

    protected class ValidationInfoAction
    extends AbstractAction {
        public ValidationInfoAction() {
            super("Show Last Validation Info");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            JOptionPane.showOptionDialog(GuiClient.this, this.createPanel(), "View Validation Info", 0, 1, null, new String[]{"OK"}, "OK");
        }

        private JPanel createPanel() {
            JPanel panel = new JPanel();
            JTextArea text = new JTextArea();
            JScrollPane areaScrollPane = new JScrollPane(text);
            areaScrollPane.setVerticalScrollBarPolicy(22);
            areaScrollPane.setPreferredSize(new Dimension(500, 400));
            if (GuiClient.this.swordclient != null) {
                SwordValidationInfo info = GuiClient.this.swordclient.getLastUnmarshallInfo();
                if (info != null) {
                    StringBuffer buffer = new StringBuffer();
                    info.createString(info, buffer, "");
                    text.setText(buffer.toString());
                } else {
                    text.setText("There is no validaiton information to display");
                }
            } else {
                text.setText("There is no validaiton information to display");
            }
            panel.add((Component)areaScrollPane, "Center");
            panel.setSize(500, 400);
            return panel;
        }
    }

    protected class AddServiceAction
    extends AbstractAction {
        public AddServiceAction() {
            super("Add Service");
            ClassLoader loader = this.getClass().getClassLoader();
            URL s = loader.getResource("images/AddServiceButton.gif");
            ImageIcon icon = new ImageIcon(s);
            this.putValue("SmallIcon", icon);
            this.putValue("ShortDescription", "Add Service");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            this.initialiseServiceDialog();
            int result = GuiClient.this.serviceDialog.show();
            if (result != 0) {
                return;
            }
            final String location = GuiClient.this.serviceDialog.getLocation();
            if (location == null || location.length() == 0) {
                JOptionPane.showMessageDialog(GuiClient.this, "You did not specify a URL", "Service Access Error", 0);
                return;
            }
            SwingWorker<String, String> worker = new SwingWorker<String, String>(){

                protected String doInBackground() throws Exception {
                    try {
                        GuiClient.this.enableActions(false);
                        GuiClient.this.setCursor(new Cursor(3));
                        String username = GuiClient.this.serviceDialog.getUsername();
                        String password = GuiClient.this.serviceDialog.getPassword();
                        GuiClient.this.initialiseServer(location, username, password);
                        this.publish(new String[]{"Requesting the document from " + location});
                        ServiceDocument document = GuiClient.this.swordclient.getServiceDocument(location, GuiClient.this.serviceDialog.getOnBehalfOf());
                        this.publish(new String[]{"Got the document"});
                        Status status = GuiClient.this.swordclient.getStatus();
                        this.publish(new String[]{"The status is: " + status});
                        SwordValidationInfo info = GuiClient.this.swordclient.getLastUnmarshallInfo();
                        if (info != null && info.getType() == SwordValidationInfoType.VALID) {
                            this.publish(new String[]{"The document was valid"});
                        } else if (info != null) {
                            this.publish(new String[]{"This document did not validate."});
                            StringBuffer buffer = new StringBuffer();
                            info.createString(info, buffer, " ");
                            this.publish(new String[]{buffer.toString()});
                        }
                        if (status.getCode() == 200) {
                            GuiClient.this.mainPanel.processServiceDocument(location, document);
                            GuiClient.this.mainPanel.addMessage(document.marshall());
                            this.publish(new String[]{"Data received for location: " + location});
                        } else {
                            JOptionPane.showMessageDialog(GuiClient.this, "Unable to access resource. Status is: " + status.toString(), "Service Access", 2);
                        }
                    }
                    catch (MalformedURLException ex) {
                        JOptionPane.showMessageDialog(GuiClient.this, "There is an error with the URL. " + ex.getMessage(), "Service Access Error", 0);
                        ex.printStackTrace();
                    }
                    catch (SWORDClientException sce) {
                        JOptionPane.showMessageDialog(GuiClient.this, "There was an error accessing the resource. " + sce.getMessage(), "Service Access Error", 0);
                        sce.printStackTrace();
                    }
                    return "Finished";
                }

                protected void done() {
                    GuiClient.this.enableActions(true);
                    GuiClient.this.setCursor(new Cursor(0));
                }

                protected void process(List<String> chunks) {
                    for (String row : chunks) {
                        String message = "status: " + row;
                        GuiClient.this.mainPanel.addMessage(message);
                        GuiClient.this.mainPanel.setStatus(message);
                    }
                }
            };
            worker.execute();
        }

        private void initialiseServiceDialog() {
            String[] users;
            String value;
            if (GuiClient.this.serviceDialog == null) {
                GuiClient.this.serviceDialog = new ServiceDialog(GuiClient.this);
            }
            if ((value = GuiClient.this.props.getProperty("serviceurls")) != null) {
                String[] services = value.split(",");
                GuiClient.this.serviceDialog.addServiceUrls(services);
            }
            if ((value = GuiClient.this.props.getProperty("users")) != null) {
                users = value.split(",");
                GuiClient.this.serviceDialog.addUserIds(users);
            }
            if ((value = GuiClient.this.props.getProperty(GuiClient.ON_BEHALF_OF)) != null) {
                users = value.split(",");
                GuiClient.this.serviceDialog.addOnBehalfOf(users);
            }
        }
    }

    protected class EditPropertiesAction
    extends AbstractAction {
        public EditPropertiesAction() {
            super("Edit Properties");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            PropertiesDialog dialog = new PropertiesDialog(GuiClient.this, GuiClient.this.props);
            dialog.show();
            GuiClient.this.processProperties();
        }
    }

    protected class QuitAction
    extends AbstractAction {
        public QuitAction() {
            super("Quit");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(81, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            GuiClient.this.saveProperties();
            System.exit(0);
        }
    }
}

