/*
 * Decompiled with CFR 0.152.
 */
package org.purl.sword.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.DefaultCellEditor;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;

public class PropertiesDialog {
    private JFrame parentFrame = null;
    private static Object[] options = new Object[]{"OK", "Cancel"};
    private JPanel controls = null;
    private Properties properties = null;
    private JTable propertiesTable;

    public PropertiesDialog(JFrame parentFrame, Properties props) {
        this.parentFrame = parentFrame;
        this.properties = props;
        this.controls = this.createControls();
    }

    protected JPanel createControls() {
        JPanel panel = new JPanel(new BorderLayout());
        this.propertiesTable = new JTable(new PropertiesModel());
        ((DefaultCellEditor)this.propertiesTable.getDefaultEditor(String.class)).setClickCountToStart(1);
        JScrollPane scrollpane = new JScrollPane(this.propertiesTable, 22, 32);
        panel.add((Component)scrollpane, "Center");
        return panel;
    }

    public int show() {
        TableCellEditor editor;
        int result = JOptionPane.showOptionDialog(this.parentFrame, this.controls, "Edit Properties", 2, -1, null, options, null);
        int column = this.propertiesTable.getEditingColumn();
        if (column > -1 && (editor = this.propertiesTable.getDefaultEditor(this.propertiesTable.getColumnClass(column))) != null) {
            editor.stopCellEditing();
        }
        return result;
    }

    public class PropertiesModel
    extends AbstractTableModel {
        private String[] columns = new String[]{"Property Name", "Value"};

        public PropertiesModel() {
            if (PropertiesDialog.this.properties == null) {
                PropertiesDialog.this.properties = new Properties();
            }
        }

        @Override
        public int getColumnCount() {
            return this.columns.length;
        }

        @Override
        public int getRowCount() {
            return PropertiesDialog.this.properties.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return this.getKeyValue(row);
            }
            String key = this.getKeyValue(row);
            return PropertiesDialog.this.properties.get(key);
        }

        @Override
        public String getColumnName(int col) {
            return this.columns[col];
        }

        public Class getColumnClass(int col) {
            return this.getValueAt(0, col).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 1;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            String key = this.getKeyValue(row);
            PropertiesDialog.this.properties.setProperty(key, (String)value);
            this.fireTableCellUpdated(row, col);
        }

        public String getKeyValue(int row) {
            int count = 0;
            Enumeration<Object> k = PropertiesDialog.this.properties.keys();
            while (k.hasMoreElements()) {
                String key = (String)k.nextElement();
                if (count == row) {
                    return key;
                }
                ++count;
            }
            return null;
        }
    }
}

