/*
 * Decompiled with CFR 0.152.
 */
package org.swordapp.server;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.log4j.Logger;
import org.swordapp.server.AuthCredentials;
import org.swordapp.server.ChecksumUtils;
import org.swordapp.server.CollectionDepositManager;
import org.swordapp.server.CollectionListManager;
import org.swordapp.server.Deposit;
import org.swordapp.server.DepositReceipt;
import org.swordapp.server.SwordAPIEndpoint;
import org.swordapp.server.SwordAuthException;
import org.swordapp.server.SwordConfiguration;
import org.swordapp.server.SwordError;
import org.swordapp.server.SwordServerException;

public class CollectionAPI
extends SwordAPIEndpoint {
    private static Logger log = Logger.getLogger(CollectionAPI.class);
    protected CollectionListManager clm = null;
    protected CollectionDepositManager cdm;

    public CollectionAPI(CollectionListManager clm, CollectionDepositManager cdm, SwordConfiguration config) {
        super(config);
        this.clm = clm;
        this.cdm = cdm;
    }

    @Override
    public void get(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.get(req, resp);
        if (this.clm == null) {
            resp.sendError(405);
            return;
        }
        AuthCredentials auth = null;
        try {
            auth = this.getAuthCredentials(req);
        }
        catch (SwordAuthException e) {
            if (e.isRetry()) {
                String s = "Basic realm=\"SWORD2\"";
                resp.setHeader("WWW-Authenticate", s);
                resp.setStatus(401);
                return;
            }
            resp.sendError(400, e.getMessage());
            return;
        }
        try {
            Feed feed = this.clm.listCollectionContents(new IRI(this.getFullUrl(req)), auth, this.config);
            if (feed == null) {
                resp.sendError(405, "This server does not support listing collection contents");
                return;
            }
            this.addGenerator(feed, this.config);
            resp.setHeader("Content-Type", "application/atom+xml;type=feed");
            feed.writeTo((Writer)resp.getWriter());
            resp.getWriter().flush();
        }
        catch (SwordServerException e) {
            throw new ServletException((Throwable)e);
        }
        catch (SwordAuthException e) {
            resp.sendError(403);
        }
        catch (SwordError se) {
            this.swordError(req, resp, se);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void post(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.post(req, resp);
        AuthCredentials auth = null;
        try {
            auth = this.getAuthCredentials(req);
        }
        catch (SwordAuthException e) {
            if (e.isRetry()) {
                String s = "Basic realm=\"SWORD2\"";
                resp.setHeader("WWW-Authenticate", s);
                resp.setStatus(401);
                return;
            }
            resp.sendError(400, e.getMessage());
            return;
        }
        Deposit deposit = null;
        try {
            String contentType = this.getContentType(req);
            boolean isMultipart = contentType.startsWith("multipart/related");
            boolean isEntryOnly = contentType.startsWith("application/atom+xml");
            boolean isBinaryOnly = !isMultipart && !isEntryOnly;
            String slug = req.getHeader("Slug");
            boolean inProgress = this.getInProgress(req);
            deposit = new Deposit();
            deposit.setInProgress(inProgress);
            deposit.setSlug(slug);
            DepositReceipt receipt = null;
            if (isMultipart) {
                this.addDepositPropertiesFromMultipart(deposit, req);
            } else if (isEntryOnly) {
                this.addDepositPropertiesFromEntry(deposit, req);
            } else if (isBinaryOnly) {
                this.addDepositPropertiesFromBinary(deposit, req);
            }
            String colUri = this.getFullUrl(req);
            receipt = this.cdm.createNew(colUri, deposit, auth, this.config);
            this.addGenerator(receipt, this.config);
            IRI location = receipt.getLocation();
            if (location == null) {
                throw new SwordServerException("No Location found in Deposit Receipt; unable to send valid response");
            }
            resp.setStatus(201);
            if (this.config.returnDepositReceipt() && !receipt.isEmpty()) {
                resp.setHeader("Content-Type", "application/atom+xml;type=entry");
                resp.setHeader("Location", location.toString());
                SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z");
                Date lastModified = receipt.getLastModified() != null ? receipt.getLastModified() : new Date();
                resp.setHeader("Last-Modified", sdf.format(lastModified));
                StringWriter writer = new StringWriter();
                Entry responseEntry = receipt.getAbderaEntry();
                responseEntry.writeTo((Writer)writer);
                String md5 = ChecksumUtils.generateMD5(writer.toString().getBytes());
                resp.setHeader("Content-MD5", md5);
                resp.getWriter().append(writer.toString());
                resp.getWriter().flush();
            } else {
                resp.setHeader("Location", location.toString());
            }
            this.cleanup(deposit);
            return;
        }
        catch (SwordError se) {
            this.cleanup(deposit);
            this.swordError(req, resp, se);
            return;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            catch (SwordServerException e) {
                throw new ServletException((Throwable)e);
                catch (NoSuchAlgorithmException e2) {
                    throw new ServletException((Throwable)e2);
                }
                catch (SwordAuthException e3) {
                    this.cleanup(deposit);
                    resp.sendError(403);
                    return;
                }
            }
        }
        finally {
            this.cleanup(deposit);
        }
    }

    protected void addGenerator(DepositReceipt doc, SwordConfiguration config) {
        Element generator = this.getGenerator(this.config);
        if (generator != null) {
            doc.getWrappedEntry().addExtension(generator);
        }
    }

    protected void addGenerator(Feed doc, SwordConfiguration config) {
        Element generator = this.getGenerator(this.config);
        if (generator != null) {
            doc.addExtension(generator);
        }
    }
}

