/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import org.commonmark.node.HardLineBreak;
import org.commonmark.node.Node;
import org.symphonyoss.symphony.messageml.elements.Element;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;
import org.symphonyoss.symphony.messageml.util.XmlPrintStream;

public class LineBreak
extends Element {
    public static final String MESSAGEML_TAG = "br";

    public LineBreak(Element parent) {
        super(parent, MESSAGEML_TAG);
    }

    @Override
    public void asPresentationML(XmlPrintStream out) {
        out.printElement(MESSAGEML_TAG);
    }

    @Override
    void buildAttribute(org.w3c.dom.Node item) throws InvalidInputException {
        throw new InvalidInputException("Attribute \"" + item.getNodeName() + "\" is not allowed in \"" + this.getMessageMLTag() + "\"");
    }

    @Override
    public String asText() {
        return "\n";
    }

    @Override
    public Node asMarkdown() {
        return new HardLineBreak();
    }

    @Override
    public void validate() throws InvalidInputException {
        this.assertNoContent();
        this.assertNoAttributes();
    }

    public String toString() {
        return "\n";
    }
}

