/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import com.fasterxml.jackson.databind.node.ObjectNode;
import org.commonmark.node.Node;
import org.commonmark.node.Text;
import org.symphonyoss.symphony.messageml.elements.Element;
import org.symphonyoss.symphony.messageml.elements.Entity;
import org.symphonyoss.symphony.messageml.elements.FormatEnum;
import org.symphonyoss.symphony.messageml.elements.Link;
import org.symphonyoss.symphony.messageml.elements.TextNode;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;
import org.symphonyoss.symphony.messageml.markdown.nodes.MentionNode;
import org.symphonyoss.symphony.messageml.util.IDataProvider;
import org.symphonyoss.symphony.messageml.util.IUserPresentation;
import org.symphonyoss.symphony.messageml.util.XmlPrintStream;

public class Mention
extends Entity {
    public static final String MESSAGEML_TAG = "mention";
    public static final String ENTITY_TYPE = "com.symphony.user.mention";
    static final String PREFIX = "@";
    private static final String ATTR_EMAIL = "email";
    private static final String ATTR_UID = "uid";
    private static final String ATTR_STRICT = "strict";
    private static final String ENTITY_SUBTYPE = "com.symphony.user.userId";
    private static final String ENTITY_VERSION = "1.0";
    private static final String MAILTO = "mailto:";
    private final IDataProvider dataProvider;
    private IUserPresentation userPresentation;
    private String email;
    private String prettyName;
    private Long uid;
    private boolean fallback = false;

    public Mention(Element parent, int entityIndex, IDataProvider dataProvider) {
        this(parent, "span", entityIndex, null, false, dataProvider, FormatEnum.MESSAGEML);
    }

    public Mention(Element parent, int entityIndex, Long uid, IDataProvider dataProvider) {
        this(parent, "span", entityIndex, uid, true, dataProvider, FormatEnum.MESSAGEML);
    }

    public Mention(Element parent, String presentationMlTag, Long uid, IDataProvider dataProvider) {
        this(parent, presentationMlTag, 0, uid, false, dataProvider, FormatEnum.PRESENTATIONML);
    }

    private Mention(Element parent, String presentationMlTag, Integer entityIndex, Long uid, Boolean fallback, IDataProvider dataProvider, FormatEnum format) {
        super(parent, MESSAGEML_TAG, presentationMlTag, format);
        this.dataProvider = dataProvider;
        this.uid = uid;
        this.fallback = fallback;
        this.entityId = this.getEntityId(entityIndex);
    }

    @Override
    protected void buildAttribute(org.w3c.dom.Node item) throws InvalidInputException {
        switch (item.getNodeName()) {
            case "email": {
                this.email = this.getStringAttribute(item);
                break;
            }
            case "uid": {
                this.uid = this.getLongAttribute(item);
                break;
            }
            case "strict": {
                this.fallback = this.getBooleanAttribute(item) == false;
                break;
            }
            default: {
                super.buildAttribute(item);
            }
        }
    }

    @Override
    public void asPresentationML(XmlPrintStream out) {
        if (this.userPresentation != null) {
            out.printElement(this.presentationMLTag, this.asText(), "class", "entity", "data-entity-id", this.entityId);
        } else if (this.uid != null) {
            out.printElement(this.presentationMLTag, String.valueOf(this.uid), "class", "entity", "data-entity-id", this.entityId);
        } else if (this.prettyName != null) {
            out.print(this.prettyName);
        } else if (this.email != null) {
            try {
                Link link = new Link(this.getParent(), this.buildMailTo(), this.dataProvider);
                for (Element child : this.getChildren()) {
                    link.addChild(child);
                }
                if (link.getChildren().isEmpty()) {
                    TextNode child = new TextNode((Element)link, this.email);
                    link.addChild(child);
                }
                link.asPresentationML(out);
            }
            catch (InvalidInputException e) {
                out.print(this.email);
            }
        }
    }

    @Override
    public Node asMarkdown() throws InvalidInputException {
        if (this.userPresentation == null) {
            if (this.prettyName != null) {
                return new Text(this.prettyName);
            }
            if (this.email != null) {
                return new Text(this.prettyName != null ? this.prettyName : this.email);
            }
            if (this.uid != null) {
                return new Text(String.valueOf(this.uid));
            }
            throw new InvalidInputException("Error processing user mention. No id or email provided");
        }
        return new MentionNode(this.userPresentation.getId(), this.userPresentation.getPrettyName(), this.userPresentation.getScreenName(), this.userPresentation.getEmail());
    }

    @Override
    public ObjectNode asEntityJson(ObjectNode parent) {
        if (this.getEntityValue() != null) {
            return super.asEntityJson(parent);
        }
        return null;
    }

    @Override
    public String asText() {
        return PREFIX + this.userPresentation.getPrettyName();
    }

    public String toString() {
        String id = this.uid == null ? (this.email == null ? "NULL" : this.email) : String.valueOf(this.uid);
        return "Mention(" + id + ")";
    }

    @Override
    public void validate() throws InvalidInputException {
        try {
            this.resolveUser();
        }
        catch (InvalidInputException e) {
            if (this.fallback) {
                this.userPresentation = null;
            }
            throw e;
        }
    }

    private void resolveUser() throws InvalidInputException {
        if (this.uid != null) {
            this.userPresentation = this.dataProvider.getUserPresentation(this.uid);
        } else if (this.email != null) {
            this.userPresentation = this.dataProvider.getUserPresentation(this.email);
        }
        if (this.userPresentation != null) {
            this.uid = this.uid == null ? this.userPresentation.getId() : this.uid.longValue();
            this.email = this.email == null ? this.userPresentation.getEmail() : this.email;
            this.prettyName = this.prettyName == null ? this.userPresentation.getPrettyName() : this.prettyName;
        }
    }

    private String buildMailTo() {
        return MAILTO + this.email;
    }

    public IUserPresentation getUserPresentation() {
        return this.userPresentation;
    }

    @Override
    protected String getEntityIdPrefix() {
        return MESSAGEML_TAG;
    }

    @Override
    protected String getEntityValue() {
        return this.uid != null ? String.valueOf(this.uid) : null;
    }

    @Override
    protected String getEntitySubType() {
        return ENTITY_SUBTYPE;
    }

    @Override
    protected String getEntityVersion() {
        return ENTITY_VERSION;
    }

    @Override
    protected String getEntityType() {
        return ENTITY_TYPE;
    }
}

