/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.commonmark.node.Document;
import org.commonmark.node.Node;
import org.symphonyoss.symphony.messageml.elements.Chime;
import org.symphonyoss.symphony.messageml.elements.Element;
import org.symphonyoss.symphony.messageml.elements.FormatEnum;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;
import org.symphonyoss.symphony.messageml.util.XmlPrintStream;

public class MessageML
extends Element {
    public static final String MESSAGEML_VERSION = "2.0";
    public static final String MESSAGEML_TAG = "messageML";
    public static final String PRESENTATIONML_TAG = "div";
    private static final String ATTR_FORMAT = "data-format";
    private static final String ATTR_VERSION = "data-version";
    private static final String PRESENTATIONML_FORMAT = "PresentationML";
    private String version;
    private boolean chime;

    public MessageML(FormatEnum format, String version) {
        super(null, MESSAGEML_TAG, format);
        this.version = version;
    }

    @Override
    protected void buildAttribute(org.w3c.dom.Node item) throws InvalidInputException {
        if (this.getFormat() == FormatEnum.PRESENTATIONML) {
            switch (item.getNodeName()) {
                case "data-format": {
                    this.setAttribute(ATTR_FORMAT, this.getStringAttribute(item));
                    break;
                }
                case "data-version": {
                    this.version = this.getStringAttribute(item);
                    break;
                }
                default: {
                    super.buildAttribute(item);
                    break;
                }
            }
        } else {
            super.buildAttribute(item);
        }
    }

    public Document asMarkdown() throws InvalidInputException {
        Document root = new Document();
        try {
            this.buildMarkdown((Node)root);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidInputException("Failed to build Markdown: " + e.getMessage());
        }
        return root;
    }

    @Override
    public void asPresentationML(XmlPrintStream out) {
        out.openElement(PRESENTATIONML_TAG, ATTR_FORMAT, PRESENTATIONML_FORMAT, ATTR_VERSION, this.version);
        for (Element child : this.getChildren()) {
            child.asPresentationML(out);
        }
        out.closeElement();
    }

    @Override
    public ObjectNode asEntityJson(ObjectNode parent) {
        if (parent == null) {
            parent = new ObjectNode(JsonNodeFactory.instance);
        }
        this.buildEntityJson(parent);
        return parent;
    }

    @Override
    public void validate() throws InvalidInputException {
        if (this.format == FormatEnum.MESSAGEML) {
            this.assertNoAttributes();
        } else if (!(this.format != FormatEnum.PRESENTATIONML || PRESENTATIONML_FORMAT.equalsIgnoreCase(this.getAttribute(ATTR_FORMAT)) && this.version != null)) {
            throw new InvalidInputException("Malformed PresentationML. The attributes \"data-format\" and \"data-version\" are required.");
        }
        if (this.isChime() && (this.getChildren().size() != 1 || !(this.getChild(0) instanceof Chime))) {
            throw new InvalidInputException("Chime messages may not have any other content");
        }
    }

    public boolean isChime() {
        return this.chime;
    }

    public void setChime(boolean chime) {
        this.chime = chime;
    }
}

